/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.client.lienzo.shape.impl.ShapeStateDefaultHandler;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.kie.workbench.common.stunner.svg.gen.codegen.PrimitiveDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.ViewDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGGeneratorFormatUtils;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGPrimitiveGeneratorUtils;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGShapeTextCodeBuilder;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.ViewGenerators;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.LayoutDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ShapeDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleSheetDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewFactory;
import org.kie.workbench.common.stunner.svg.gen.model.ViewRefDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.SVGModelUtils;
import org.kie.workbench.common.stunner.svg.gen.model.impl.ViewDefinitionImpl;
import org.uberfire.annotations.processors.exceptions.GenerationException;

public class SVGViewDefinitionGenerator
extends AbstractGenerator
implements ViewDefinitionGenerator<ViewDefinition<SVGShapeView>> {
    public static final String PRIM_CHILD_TEMPLATE = "view.addChild(%1s);";
    private static final String SVG_CHILD_TEMPLATE = "view.addSVGChild(%1s, %1s.this.%1sBasicView());";

    @Override
    public StringBuffer generate(ViewFactory viewFactory, ViewDefinition<SVGShapeView> viewDefinition) throws GeneratorException {
        StringBuffer result = null;
        String factoryName = viewFactory.getSimpleName();
        String viewId = viewDefinition.getId();
        String methodName = viewDefinition.getFactoryMethodName();
        ShapeDefinition main = viewDefinition.getMain();
        if (null != main) {
            HashMap<String, Object> root = new HashMap<String, Object>();
            LinkedList<String> childrenRaw = new LinkedList<String>();
            List<PrimitiveDefinition> children = viewDefinition.getChildren();
            for (PrimitiveDefinition child : children) {
                String childId = SVGGeneratorFormatUtils.getValidInstanceId(child);
                String childRaw = SVGPrimitiveGeneratorUtils.generateSvgPrimitive(childId, SVGViewDefinitionGenerator::getGenerator, child);
                if (null == childRaw) continue;
                childrenRaw.add(childRaw);
                childrenRaw.add(AbstractGenerator.formatString(PRIM_CHILD_TEMPLATE, childId));
            }
            LinkedList svgChildrenRaw = new LinkedList();
            List<ViewRefDefinition> svgViewRefs = viewDefinition.getSVGViewRefs();
            svgViewRefs.forEach(viewRef -> {
                String parent = viewRef.getParent();
                String svgName = viewRef.getFilePath();
                String viewRefId = viewRef.getViewRefId();
                boolean existReferencedView = viewFactory.getViewDefinitions().stream().anyMatch(def -> viewRefId.equals(def.getId()));
                if (!existReferencedView) {
                    throw new RuntimeException("The view [" + viewRefId + "] references another the view [" + svgName + "], but no factory method for it exists in [" + viewFactory.getImplementedType() + "]");
                }
                String childRaw = SVGViewDefinitionGenerator.formatString(SVG_CHILD_TEMPLATE, parent, factoryName, viewRefId);
                svgChildrenRaw.add(childRaw);
            });
            LinkedList stateViews = new LinkedList();
            SVGModelUtils.visit(viewDefinition, p -> {
                if (p instanceof ShapeDefinition && SVGPrimitiveGeneratorUtils.CAN_GENERATE_PRIMITIVE_CODE.test((PrimitiveDefinition)p)) {
                    ShapeDefinition shapeDefinition = (ShapeDefinition)p;
                    shapeDefinition.getStateDefinition().ifPresent(s -> stateViews.add((ShapeDefinition)p));
                }
            });
            String stateViewIds = stateViews.isEmpty() ? "view" : stateViews.stream().map(d -> SVGGeneratorFormatUtils.getValidInstanceId(d.getId())).collect(Collectors.joining(","));
            String stateViewPolicyType = stateViews.isEmpty() ? ShapeStateDefaultHandler.RenderType.STROKE.name() : ((ShapeDefinition)stateViews.get(0)).getStateDefinition().get().name();
            String stateViewPolicy = ShapeStateDefaultHandler.RenderType.class.getName().replace("$", ".") + "." + stateViewPolicyType.toUpperCase();
            PrimitiveDefinitionGenerator<PrimitiveDefinition<?>> mainGenerator = SVGViewDefinitionGenerator.getGenerator(main);
            StringBuffer mainBuffer = mainGenerator.generate(main);
            LayoutDefinition mainLayoutDefinition = main.getLayoutDefinition();
            String mainLayoutRaw = SVGPrimitiveGeneratorUtils.formatLayout(mainLayoutDefinition);
            StyleSheetDefinition globalStyleSheetDefinition = ((ViewDefinitionImpl)viewDefinition).getGlobalStyleSheetDefinition();
            String viewTextRaw = null != globalStyleSheetDefinition ? SVGShapeTextCodeBuilder.generate("view", viewId, globalStyleSheetDefinition) : "";
            root.put("viewId", viewId);
            root.put("name", methodName);
            root.put("mainShape", mainBuffer.toString());
            root.put("layout", mainLayoutRaw);
            root.put("width", SVGViewDefinitionGenerator.formatDouble(viewDefinition.getWidth()));
            root.put("height", SVGViewDefinitionGenerator.formatDouble(viewDefinition.getHeight()));
            root.put("text", viewTextRaw);
            root.put("stateViewIds", stateViewIds);
            root.put("stateViewPolicy", stateViewPolicy);
            root.put("children", childrenRaw);
            root.put("svgChildren", svgChildrenRaw);
            try {
                result = this.writeTemplate(root);
            }
            catch (GenerationException e) {
                throw new GeneratorException(e);
            }
        }
        return result;
    }

    private static PrimitiveDefinitionGenerator<PrimitiveDefinition<?>> getGenerator(PrimitiveDefinition main) {
        PrimitiveDefinitionGenerator<?>[] array = ViewGenerators.newPrimitiveDefinitionGenerators();
        LinkedList list = new LinkedList();
        Collections.addAll(list, array);
        return list.stream().filter(generator -> generator.getDefinitionType().equals(main.getClass())).findFirst().orElse(null);
    }

    @Override
    protected String getTemplatePath() {
        return "SVGShapeView";
    }
}

