/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.model;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;

public final class StyleSheetDefinition {
    private final String cssPath;
    private final Map<String, StyleDefinition> styleDefinitions = new LinkedHashMap<String, StyleDefinition>();

    public StyleSheetDefinition(String cssPath) {
        this.cssPath = cssPath;
    }

    public StyleSheetDefinition addStyle(String name, StyleDefinition styleDefinition) {
        Arrays.stream(name.split(",")).forEach(n -> this.styleDefinitions.put(n.trim(), styleDefinition));
        return this;
    }

    public StyleDefinition getStyle(String name) {
        return this.styleDefinitions.get(name.trim());
    }

    public StyleDefinition getStyle(List<String> names) {
        StyleDefinition result = null;
        for (String name : names) {
            StyleDefinition style = this.getStyle(name);
            if (null != style && null == result) {
                result = style.copy();
                continue;
            }
            if (null == style) continue;
            result.add(style.copy());
        }
        return result;
    }

    public String getCssPath() {
        return this.cssPath;
    }
}

