/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.datamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.Annotation;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.MethodInfo;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.datamodel.model.LazyModelField;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleIncrementalPayload;
import org.kie.workbench.common.services.datamodel.service.IncrementalDataModelService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleUtilities;
import org.kie.workbench.common.widgets.client.datamodel.EnumDropDownDataFactory;
import org.kie.workbench.common.widgets.client.datamodel.FactNameToFQCNHandleRegistry;
import org.kie.workbench.common.widgets.client.datamodel.FilteredEnumLists;
import org.kie.workbench.common.widgets.client.datamodel.OracleUtils;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class AsyncPackageDataModelOracleImpl
implements AsyncPackageDataModelOracle {
    @Inject
    protected Caller<IncrementalDataModelService> service;
    private Path resourcePath;
    protected String projectName;
    private String packageName = "";
    private Imports imports = new Imports();
    private List<String> packageNames = new ArrayList<String>();
    protected Map<String, ModelField[]> projectModelFields = new HashMap<String, ModelField[]>();
    protected Map<String, String> projectFieldParametersType = new HashMap<String, String>();
    protected Map<String, Boolean> projectEventTypes = new HashMap<String, Boolean>();
    protected Map<String, TypeSource> projectTypeSources = new HashMap<String, TypeSource>();
    protected Map<String, List<String>> projectSuperTypes = new HashMap<String, List<String>>();
    protected Map<String, Set<Annotation>> projectTypeAnnotations = new HashMap<String, Set<Annotation>>();
    protected Map<String, Map<String, Set<Annotation>>> projectTypeFieldsAnnotations = new HashMap<String, Map<String, Set<Annotation>>>();
    protected Map<String, String[]> projectJavaEnumLists = new HashMap<String, String[]>();
    protected Map<String, List<MethodInfo>> projectMethodInformation = new HashMap<String, List<MethodInfo>>();
    protected Map<String, Boolean> projectCollectionTypes = new HashMap<String, Boolean>();
    private Map<String, ModelField[]> filteredModelFields = new HashMap<String, ModelField[]>();
    private Map<String, String> filteredFieldParametersType = new HashMap<String, String>();
    private FilteredEnumLists filteredEnumLists = new FilteredEnumLists();
    private Map<String, Boolean> filteredEventTypes = new HashMap<String, Boolean>();
    private Map<String, Boolean> filteredCollectionTypes = new HashMap<String, Boolean>();
    private Map<String, TypeSource> filteredTypeSources = new HashMap<String, TypeSource>();
    protected Map<String, List<String>> filteredSuperTypes = new HashMap<String, List<String>>();
    protected Map<String, Set<Annotation>> filteredTypeAnnotations = new HashMap<String, Set<Annotation>>();
    protected Map<String, Map<String, Set<Annotation>>> filteredTypeFieldsAnnotations = new HashMap<String, Map<String, Set<Annotation>>>();
    private Map<String, String> filteredGlobalTypes = new HashMap<String, String>();
    private Map<String, String[]> packageWorkbenchEnumLists = new HashMap<String, String[]>();
    private List<DSLSentence> packageDSLConditionSentences = new ArrayList<DSLSentence>();
    private List<DSLSentence> packageDSLActionSentences = new ArrayList<DSLSentence>();
    private Map<String, String> packageGlobalTypes = new HashMap<String, String>();
    private FactNameToFQCNHandleRegistry factNameToFQCNHandleRegistry = new FactNameToFQCNHandleRegistry();

    @Override
    public void init(Path resourcePath) {
        this.resourcePath = (Path)PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
    }

    @Override
    public Path getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public List<String> getPackageNames() {
        return this.packageNames;
    }

    @Override
    public String[] getFactTypes() {
        Object[] types = this.filteredModelFields.keySet().toArray(new String[this.filteredModelFields.size()]);
        Arrays.sort(types);
        return types;
    }

    @Override
    public String[] getAllFactTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(this.projectModelFields.keySet());
        Object[] result = new String[types.size()];
        types.toArray(result);
        Arrays.sort(result);
        return result;
    }

    @Override
    public String[] getExternalFactTypes() {
        String[] allTypes = this.getAllFactTypes();
        ArrayList<String> externalTypes = new ArrayList<String>();
        for (String type : allTypes) {
            String packageName = AsyncPackageDataModelOracleUtilities.getPackageName(type);
            if (packageName.equals(this.packageName)) continue;
            externalTypes.add(type);
        }
        Object[] result = new String[externalTypes.size()];
        externalTypes.toArray(result);
        Arrays.sort(result);
        return result;
    }

    @Override
    public String getFQCNByFactName(String factName) {
        if (this.factNameToFQCNHandleRegistry.contains(factName)) {
            return this.factNameToFQCNHandleRegistry.get(factName);
        }
        if (factName.contains(".")) {
            return factName;
        }
        return factName;
    }

    @Override
    public String getFactNameFromType(String type) {
        if (type == null || type.isEmpty()) {
            return null;
        }
        if (this.filteredModelFields.containsKey(type)) {
            return type;
        }
        for (Map.Entry<String, ModelField[]> entry : this.filteredModelFields.entrySet()) {
            for (ModelField mf : entry.getValue()) {
                if (!"this".equals(mf.getName()) || !type.equals(mf.getClassName())) continue;
                return entry.getKey();
            }
        }
        String fgcnByFactName = this.getFQCNByFactName(type);
        if (this.projectModelFields.containsKey(fgcnByFactName)) {
            return AsyncPackageDataModelOracleUtilities.getTypeName(fgcnByFactName);
        }
        return null;
    }

    @Override
    public boolean isFactTypeRecognized(String factType) {
        return this.filteredModelFields.containsKey(factType) || this.factNameToFQCNHandleRegistry.map.containsValue(factType);
    }

    @Override
    public void isFactTypeAnEvent(final String factType, final Callback<Boolean> callback) {
        if (factType == null || factType.isEmpty()) {
            callback.callback((Object)false);
            return;
        }
        Boolean isFactTypeAnEvent = this.filteredEventTypes.get(factType);
        if (isFactTypeAnEvent == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    Boolean isFactTypeAnEvent = (Boolean)AsyncPackageDataModelOracleImpl.this.filteredEventTypes.get(factType);
                    if (isFactTypeAnEvent == null) {
                        isFactTypeAnEvent = false;
                        AsyncPackageDataModelOracleImpl.this.filteredEventTypes.put(factType, isFactTypeAnEvent);
                    }
                    callback.callback((Object)isFactTypeAnEvent);
                }
            })).getUpdates(this.resourcePath, this.imports, factType);
        } else {
            callback.callback((Object)isFactTypeAnEvent);
        }
    }

    @Override
    public void getTypeSource(final String factType, final Callback<TypeSource> callback) {
        TypeSource typeSource = this.filteredTypeSources.get(factType);
        if (typeSource == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    TypeSource typeSource = (TypeSource)AsyncPackageDataModelOracleImpl.this.filteredTypeSources.get(factType);
                    callback.callback((Object)typeSource);
                }
            })).getUpdates(this.resourcePath, this.imports, factType);
        } else {
            callback.callback((Object)typeSource);
        }
    }

    @Override
    public void getSuperType(String factType, final Callback<String> callback) {
        this.getSuperTypes(factType, new Callback<List<String>>(){

            public void callback(List<String> result) {
                if (result != null) {
                    callback.callback((Object)result.get(0));
                } else {
                    callback.callback(null);
                }
            }
        });
    }

    @Override
    public void getSuperTypes(final String factType, final Callback<List<String>> callback) {
        List<String> superTypes = this.filteredSuperTypes.get(factType);
        if (superTypes == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    callback.callback(AsyncPackageDataModelOracleImpl.this.filteredSuperTypes.get(factType));
                }
            })).getUpdates(this.resourcePath, this.imports, factType);
        } else {
            callback.callback(superTypes);
        }
    }

    @Override
    public void getTypeAnnotations(final String factType, final Callback<Set<Annotation>> callback) {
        Set<Annotation> typeAnnotations = this.filteredTypeAnnotations.get(factType);
        if (typeAnnotations == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    Set typeAnnotations = AsyncPackageDataModelOracleImpl.this.filteredTypeAnnotations.get(factType);
                    if (typeAnnotations == null) {
                        typeAnnotations = Collections.EMPTY_SET;
                        AsyncPackageDataModelOracleImpl.this.filteredTypeAnnotations.put(factType, typeAnnotations);
                    }
                    callback.callback((Object)typeAnnotations);
                }
            })).getUpdates(this.resourcePath, this.imports, factType);
        } else {
            callback.callback(typeAnnotations);
        }
    }

    @Override
    public void getTypeFieldsAnnotations(final String factType, final Callback<Map<String, Set<Annotation>>> callback) {
        Map<String, Set<Annotation>> typeFieldsAnnotations = this.filteredTypeFieldsAnnotations.get(factType);
        if (typeFieldsAnnotations == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    Map typeFieldsAnnotations = AsyncPackageDataModelOracleImpl.this.filteredTypeFieldsAnnotations.get(factType);
                    if (typeFieldsAnnotations == null) {
                        typeFieldsAnnotations = Collections.EMPTY_MAP;
                        AsyncPackageDataModelOracleImpl.this.filteredTypeFieldsAnnotations.put(factType, typeFieldsAnnotations);
                    }
                    callback.callback((Object)typeFieldsAnnotations);
                }
            })).getUpdates(this.resourcePath, this.imports, factType);
        } else {
            callback.callback(typeFieldsAnnotations);
        }
    }

    @Override
    public void getFieldCompletions(final String factType, final Callback<ModelField[]> callback) {
        final String fgcnByFactName = this.getFQCNByFactName(factType);
        ModelField[] fields = this.getModelFields(factType);
        if (fields == null || fields.length == 0) {
            fields = this.projectModelFields.get(fgcnByFactName);
            if (fields == null || this.isLazyProxy(fields)) {
                fields = null;
            } else {
                AsyncPackageDataModelOracleUtilities.correctModelFields(this.packageName, fields, this.imports);
            }
        }
        if (fields == null || fields.length == 0) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    if (dataModel.getModelFields().get(fgcnByFactName) == null || ((ModelField[])dataModel.getModelFields().get(fgcnByFactName)).length == 0) {
                        callback.callback((Object)new ModelField[0]);
                    } else {
                        AsyncPackageDataModelOracleImpl.this.getFieldCompletions(factType, (Callback<ModelField[]>)callback);
                    }
                }
            })).getUpdates(this.resourcePath, this.imports, fgcnByFactName);
        } else {
            callback.callback((Object)fields);
        }
    }

    private ModelField[] getModelFields(String modelClassName) {
        String shortName = this.getFactNameFromType(modelClassName);
        if (!this.filteredModelFields.containsKey(shortName)) {
            return new ModelField[0];
        }
        ModelField[] fields = this.filteredModelFields.get(shortName);
        if (this.isLazyProxy(fields)) {
            return null;
        }
        return fields;
    }

    @Override
    public void getFieldCompletions(String factType, final FieldAccessorsAndMutators accessorOrMutator, final Callback<ModelField[]> callback) {
        this.getFieldCompletions(factType, new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                ArrayList<ModelField> result = new ArrayList<ModelField>();
                for (ModelField field : fields) {
                    if (!FieldAccessorsAndMutators.compare((FieldAccessorsAndMutators)accessorOrMutator, (FieldAccessorsAndMutators)field.getAccessorsAndMutators())) continue;
                    result.add(field);
                }
                callback.callback((Object)result.toArray(new ModelField[result.size()]));
            }
        });
    }

    private boolean isLazyProxy(ModelField[] modelFields) {
        if (modelFields == null) {
            return false;
        }
        if (modelFields.length != 1) {
            return false;
        }
        return modelFields[0] instanceof LazyModelField;
    }

    @Override
    public String getFieldType(String modelClassName, String fieldName) {
        ModelField field = this.getField(modelClassName, fieldName);
        if (field != null) {
            return field.getType();
        }
        String fgcnModelClassName = this.getFQCNByFactName(modelClassName);
        List<MethodInfo> mis = this.projectMethodInformation.get(fgcnModelClassName);
        if (mis != null) {
            for (MethodInfo mi : mis) {
                if (!mi.getName().equals(fieldName)) continue;
                return mi.getGenericType();
            }
        }
        return null;
    }

    @Override
    public String getFieldClassName(String modelClassName, String fieldName) {
        ModelField field = this.getField(modelClassName, fieldName);
        if (field != null) {
            return field.getClassName();
        }
        String fgcnModelClassName = this.getFQCNByFactName(modelClassName);
        List<MethodInfo> mis = this.projectMethodInformation.get(fgcnModelClassName);
        if (mis != null) {
            for (MethodInfo mi : mis) {
                if (!mi.getName().equals(fieldName)) continue;
                return mi.getReturnClassType();
            }
        }
        return null;
    }

    private ModelField getField(String modelClassName, String fieldName) {
        String fgcnByFactName = this.getFQCNByFactName(modelClassName);
        ModelField[] fields = this.projectModelFields.get(fgcnByFactName);
        if (fields == null) {
            return null;
        }
        for (ModelField modelField : fields) {
            if (!modelField.getName().equals(fieldName)) continue;
            return AsyncPackageDataModelOracleUtilities.correctModelFields(this.packageName, this.imports, modelField);
        }
        return null;
    }

    @Override
    public String getParametricFieldType(String factType, String fieldName) {
        String qualifiedFactFieldName = factType + "#" + fieldName;
        return this.filteredFieldParametersType.get(qualifiedFactFieldName);
    }

    @Override
    public void getOperatorCompletions(String factType, String fieldName, final Callback<String[]> callback) {
        String fieldType = this.getFieldType(factType, fieldName);
        if (fieldType == null) {
            callback.callback((Object)OperatorsOracle.STANDARD_OPERATORS);
            return;
        }
        if (fieldName.equals("this")) {
            this.isFactTypeAnEvent(factType, new Callback<Boolean>(){

                public void callback(Boolean isFactTypeAnEvent) {
                    if (Boolean.TRUE.equals(isFactTypeAnEvent)) {
                        callback.callback((Object)OracleUtils.joinArrays(OperatorsOracle.STANDARD_OPERATORS, OperatorsOracle.SIMPLE_CEP_OPERATORS, OperatorsOracle.COMPLEX_CEP_OPERATORS));
                        return;
                    }
                    callback.callback((Object)OperatorsOracle.STANDARD_OPERATORS);
                }
            });
        } else {
            if (fieldType.equals("String")) {
                callback.callback((Object)OracleUtils.joinArrays(OperatorsOracle.STRING_OPERATORS, new String[][]{OperatorsOracle.EXPLICIT_LIST_OPERATORS}));
                return;
            }
            if (DataType.isNumeric((String)fieldType)) {
                callback.callback((Object)OracleUtils.joinArrays(OperatorsOracle.COMPARABLE_OPERATORS, new String[][]{OperatorsOracle.EXPLICIT_LIST_OPERATORS}));
                return;
            }
            if (fieldType.equals("Date")) {
                callback.callback((Object)OracleUtils.joinArrays(OperatorsOracle.COMPARABLE_OPERATORS, OperatorsOracle.EXPLICIT_LIST_OPERATORS, OperatorsOracle.SIMPLE_CEP_OPERATORS));
                return;
            }
            if (fieldType.equals("Comparable")) {
                callback.callback((Object)OperatorsOracle.COMPARABLE_OPERATORS);
                return;
            }
            if (fieldType.equals("Collection")) {
                callback.callback((Object)OperatorsOracle.COLLECTION_OPERATORS);
                return;
            }
            callback.callback((Object)OperatorsOracle.STANDARD_OPERATORS);
        }
    }

    @Override
    public void getConnectiveOperatorCompletions(String factType, String fieldName, final Callback<String[]> callback) {
        String fieldType = this.getFieldType(factType, fieldName);
        if (fieldType == null) {
            callback.callback((Object)OperatorsOracle.STANDARD_CONNECTIVES);
            return;
        }
        if (fieldName.equals("this")) {
            this.isFactTypeAnEvent(factType, new Callback<Boolean>(){

                public void callback(Boolean isFactTypeAnEvent) {
                    if (Boolean.TRUE.equals(isFactTypeAnEvent)) {
                        callback.callback((Object)OracleUtils.joinArrays(OperatorsOracle.STANDARD_CONNECTIVES, OperatorsOracle.SIMPLE_CEP_CONNECTIVES, OperatorsOracle.COMPLEX_CEP_CONNECTIVES));
                        return;
                    }
                    callback.callback((Object)OperatorsOracle.STANDARD_CONNECTIVES);
                }
            });
        } else {
            if (fieldType.equals("String")) {
                callback.callback((Object)OperatorsOracle.STRING_CONNECTIVES);
                return;
            }
            if (DataType.isNumeric((String)fieldType)) {
                callback.callback((Object)OperatorsOracle.COMPARABLE_CONNECTIVES);
                return;
            }
            if (fieldType.equals("Date")) {
                callback.callback((Object)OracleUtils.joinArrays(OperatorsOracle.COMPARABLE_CONNECTIVES, new String[][]{OperatorsOracle.SIMPLE_CEP_CONNECTIVES}));
                return;
            }
            if (fieldType.equals("Comparable")) {
                callback.callback((Object)OperatorsOracle.COMPARABLE_CONNECTIVES);
                return;
            }
            if (fieldType.equals("Collection")) {
                callback.callback((Object)OperatorsOracle.COLLECTION_CONNECTIVES);
                return;
            }
            callback.callback((Object)OperatorsOracle.STANDARD_CONNECTIVES);
        }
    }

    @Override
    public void getMethodInfos(String factType, Callback<List<MethodInfo>> callback) {
        this.getMethodInfos(factType, -1, callback);
    }

    @Override
    public void getMethodInfos(String factType, final int parameterCount, final Callback<List<MethodInfo>> callback) {
        final String fqcnByFactName = this.getFQCNByFactName(factType);
        List<MethodInfo> methodInformation = this.projectMethodInformation.get(fqcnByFactName);
        if (methodInformation == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    List<MethodInfo> methodInformation = AsyncPackageDataModelOracleImpl.this.projectMethodInformation.get(fqcnByFactName);
                    callback.callback((Object)AsyncPackageDataModelOracleImpl.this.getMethodInfos(parameterCount, methodInformation));
                }
            })).getUpdates(this.resourcePath, this.imports, fqcnByFactName);
        } else {
            callback.callback(this.getMethodInfos(parameterCount, methodInformation));
        }
    }

    private List<MethodInfo> getMethodInfos(int paramCount, List<MethodInfo> allMethodInfos) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        if (allMethodInfos == null) {
            return methodInfos;
        }
        for (MethodInfo mi : allMethodInfos) {
            if (paramCount != -1 && mi.getParams().size() > paramCount) continue;
            methodInfos.add(mi);
        }
        return AsyncPackageDataModelOracleUtilities.correctMethodInformation(this.packageName, methodInfos, this.imports);
    }

    @Override
    public void getMethodParams(String factType, final String methodNameWithParams, final Callback<List<String>> callback) {
        final String fqcnFactName = this.getFQCNByFactName(factType);
        List<MethodInfo> methodInformation = this.projectMethodInformation.get(fqcnFactName);
        if (methodInformation == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    List<MethodInfo> methodInformation = AsyncPackageDataModelOracleImpl.this.projectMethodInformation.get(fqcnFactName);
                    callback.callback((Object)AsyncPackageDataModelOracleImpl.this.getMethodParams(methodInformation, methodNameWithParams));
                }
            })).getUpdates(this.resourcePath, this.imports, fqcnFactName);
        } else {
            callback.callback(this.getMethodParams(methodInformation, methodNameWithParams));
        }
    }

    private List<String> getMethodParams(List<MethodInfo> methodInfos, String methodNameWithParams) {
        ArrayList<String> methodParams = new ArrayList<String>();
        for (MethodInfo methodInfo : methodInfos) {
            if (!methodInfo.getNameWithParameters().startsWith(methodNameWithParams)) continue;
            methodParams.addAll(methodInfo.getParams());
        }
        return methodParams;
    }

    @Override
    public void getMethodInfo(String factType, final String methodNameWithParams, final Callback<MethodInfo> callback) {
        final String fqcnFactName = this.getFQCNByFactName(factType);
        List<MethodInfo> methodInformation = this.projectMethodInformation.get(fqcnFactName);
        if (methodInformation == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    List<MethodInfo> methodInformation = AsyncPackageDataModelOracleImpl.this.projectMethodInformation.get(fqcnFactName);
                    callback.callback((Object)AsyncPackageDataModelOracleImpl.this.getMethodInfo(methodInformation, methodNameWithParams));
                }
            })).getUpdates(this.resourcePath, this.imports, factType);
        } else {
            callback.callback((Object)this.getMethodInfo(methodInformation, methodNameWithParams));
        }
    }

    private MethodInfo getMethodInfo(List<MethodInfo> methodInfos, String methodNameWithParams) {
        for (MethodInfo methodInfo : methodInfos) {
            if (!methodInfo.getNameWithParameters().equals(methodNameWithParams)) continue;
            return AsyncPackageDataModelOracleUtilities.correctMethodInformation(this.packageName, methodInfo, this.imports);
        }
        return null;
    }

    @Override
    public String[] getGlobalVariables() {
        return OracleUtils.toStringArray(this.filteredGlobalTypes.keySet());
    }

    @Override
    public String getGlobalVariable(String name) {
        return this.filteredGlobalTypes.get(name);
    }

    @Override
    public boolean isGlobalVariable(String name) {
        return this.filteredGlobalTypes.containsKey(name);
    }

    @Override
    public void getFieldCompletionsForGlobalVariable(String varName, final Callback<ModelField[]> callback) {
        this.getFieldCompletions(this.getGlobalVariable(varName), new Callback<ModelField[]>(){

            public void callback(ModelField[] result) {
                callback.callback((Object)result);
            }
        });
    }

    @Override
    public void getMethodInfosForGlobalVariable(String varName, final Callback<List<MethodInfo>> callback) {
        final String factType = this.packageGlobalTypes.get(varName);
        List<MethodInfo> methodInformation = this.projectMethodInformation.get(factType);
        if (methodInformation == null) {
            ((IncrementalDataModelService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleIncrementalPayload>(){

                public void callback(PackageDataModelOracleIncrementalPayload dataModel) {
                    AsyncPackageDataModelOracleUtilities.populateDataModelOracle(AsyncPackageDataModelOracleImpl.this, dataModel);
                    callback.callback(AsyncPackageDataModelOracleImpl.this.projectMethodInformation.get(factType));
                }
            })).getUpdates(this.resourcePath, this.imports, factType);
        } else {
            callback.callback(methodInformation);
        }
    }

    @Override
    public String[] getGlobalCollections() {
        ArrayList<String> globalCollections = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.filteredGlobalTypes.entrySet()) {
            if (!this.filteredCollectionTypes.containsKey(e.getValue()) || !Boolean.TRUE.equals(this.filteredCollectionTypes.get(e.getValue()))) continue;
            globalCollections.add(e.getKey());
        }
        return OracleUtils.toStringArray(globalCollections);
    }

    @Override
    public List<DSLSentence> getDSLConditions() {
        return Collections.unmodifiableList(this.packageDSLConditionSentences);
    }

    @Override
    public List<DSLSentence> getDSLActions() {
        return Collections.unmodifiableList(this.packageDSLActionSentences);
    }

    @Override
    public DropDownData getEnums(String type, String field) {
        return this.getEnums(type, field, new HashMap<String, String>());
    }

    @Override
    public DropDownData getEnums(String type, String field, Map<String, String> currentValueMap) {
        return new EnumDropDownDataFactory(this.filteredEnumLists, currentValueMap).getEnums(type, field);
    }

    @Override
    public String[] getEnumValues(String factType, String factField) {
        return this.filteredEnumLists.getEnumValues(factType, factField);
    }

    @Override
    public boolean hasEnums(String factType, String field) {
        return this.hasEnums(factType + "#" + field);
    }

    @Override
    public boolean hasEnums(String qualifiedFactField) {
        return this.filteredEnumLists.hasEnums(qualifiedFactField);
    }

    @Override
    public boolean isDependentEnum(String factType, String parentField, String childField) {
        return this.filteredEnumLists.isDependentEnum(factType, parentField, childField);
    }

    @Override
    public void filter(Imports imports) {
        this.imports = imports;
        this.filter();
    }

    @Override
    public void filter() {
        this.filteredModelFields = new HashMap<String, ModelField[]>();
        this.filteredModelFields.putAll(AsyncPackageDataModelOracleUtilities.filterModelFields(this.packageName, this.imports, this.projectModelFields, this.factNameToFQCNHandleRegistry));
        AsyncPackageDataModelOracleUtilities.visitMethodInformation(this.projectMethodInformation, this.factNameToFQCNHandleRegistry);
        this.filteredGlobalTypes = new HashMap<String, String>();
        this.filteredGlobalTypes.putAll(AsyncPackageDataModelOracleUtilities.filterGlobalTypes(this.packageName, this.imports, this.packageGlobalTypes));
        this.filteredCollectionTypes = new HashMap<String, Boolean>();
        this.filteredCollectionTypes.putAll(AsyncPackageDataModelOracleUtilities.filterCollectionTypes(this.packageName, this.imports, this.projectCollectionTypes));
        this.filteredEventTypes = new HashMap<String, Boolean>();
        this.filteredEventTypes.putAll(AsyncPackageDataModelOracleUtilities.filterEventTypes(this.packageName, this.imports, this.projectEventTypes));
        this.filteredTypeSources = new HashMap<String, TypeSource>();
        this.filteredTypeSources.putAll(AsyncPackageDataModelOracleUtilities.filterTypeSources(this.packageName, this.imports, this.projectTypeSources));
        this.filteredSuperTypes = new HashMap<String, List<String>>();
        this.filteredSuperTypes.putAll(AsyncPackageDataModelOracleUtilities.filterSuperTypes(this.packageName, this.imports, this.projectSuperTypes));
        this.filteredTypeAnnotations = new HashMap<String, Set<Annotation>>();
        this.filteredTypeAnnotations.putAll(AsyncPackageDataModelOracleUtilities.filterTypeAnnotations(this.packageName, this.imports, this.projectTypeAnnotations));
        this.filteredTypeFieldsAnnotations = new HashMap<String, Map<String, Set<Annotation>>>();
        this.filteredTypeFieldsAnnotations.putAll(AsyncPackageDataModelOracleUtilities.filterTypeFieldsAnnotations(this.packageName, this.imports, this.projectTypeFieldsAnnotations));
        this.filteredEnumLists = new FilteredEnumLists();
        this.filteredEnumLists.putAll(this.packageWorkbenchEnumLists);
        this.filteredEnumLists.putAll(AsyncPackageDataModelOracleUtilities.filterEnumDefinitions(this.packageName, this.imports, this.projectJavaEnumLists));
        this.filteredFieldParametersType = new HashMap<String, String>();
        this.filteredFieldParametersType.putAll(AsyncPackageDataModelOracleUtilities.filterFieldParametersTypes(this.packageName, this.imports, this.projectFieldParametersType));
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void addModelFields(Map<String, ModelField[]> modelFields) {
        this.projectModelFields.putAll(modelFields);
    }

    @Override
    public void addFieldParametersType(Map<String, String> fieldParametersType) {
        this.projectFieldParametersType.putAll(fieldParametersType);
    }

    @Override
    public void addEventTypes(Map<String, Boolean> eventTypes) {
        this.projectEventTypes.putAll(eventTypes);
    }

    @Override
    public void addTypeSources(Map<String, TypeSource> typeSources) {
        this.projectTypeSources.putAll(typeSources);
    }

    @Override
    public void addSuperTypes(Map<String, List<String>> superTypes) {
        this.projectSuperTypes.putAll(superTypes);
    }

    @Override
    public void addTypeAnnotations(Map<String, Set<Annotation>> annotations) {
        this.projectTypeAnnotations.putAll(annotations);
    }

    @Override
    public void addTypeFieldsAnnotations(Map<String, Map<String, Set<Annotation>>> typeFieldsAnnotations) {
        this.projectTypeFieldsAnnotations.putAll(typeFieldsAnnotations);
    }

    @Override
    public void addJavaEnumDefinitions(Map<String, String[]> dataEnumLists) {
        this.projectJavaEnumLists.putAll(dataEnumLists);
    }

    @Override
    public void addMethodInformation(Map<String, List<MethodInfo>> methodInformation) {
        this.projectMethodInformation.putAll(methodInformation);
    }

    @Override
    public void addCollectionTypes(Map<String, Boolean> collectionTypes) {
        this.projectCollectionTypes.putAll(collectionTypes);
    }

    @Override
    public void addPackageNames(List<String> packageNames) {
        this.packageNames.addAll(packageNames);
    }

    @Override
    public void addWorkbenchEnumDefinitions(Map<String, String[]> dataEnumLists) {
        this.packageWorkbenchEnumLists.putAll(dataEnumLists);
    }

    @Override
    public void addDslConditionSentences(List<DSLSentence> dslConditionSentences) {
        this.packageDSLConditionSentences.addAll(dslConditionSentences);
    }

    @Override
    public void addDslActionSentences(List<DSLSentence> dslActionSentences) {
        this.packageDSLActionSentences.addAll(dslActionSentences);
    }

    @Override
    public void addGlobals(Map<String, String> packageGlobalTypes) {
        this.packageGlobalTypes.putAll(packageGlobalTypes);
    }
}

