/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.PackageContextProvider;
import org.kie.workbench.common.widgets.client.resources.i18n.NewItemPopupConstants;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

@ApplicationScoped
public class NewResourcePresenter {
    @Inject
    private View view;
    private NewResourceHandler activeHandler = null;

    @PostConstruct
    private void setup() {
        this.view.init(this);
    }

    public void show(NewResourceHandler handler) {
        this.activeHandler = (NewResourceHandler)PortablePreconditions.checkNotNull((String)"handler", (Object)handler);
        this.view.show();
        this.view.setActiveHandler(this.activeHandler);
        this.view.setTitle(NewItemPopupConstants.INSTANCE.popupTitle() + " " + this.getActiveHandlerDescription());
    }

    public void validate(String fileName, ValidatorWithReasonCallback callback) {
        if (this.activeHandler != null) {
            this.activeHandler.validate(fileName, callback);
        }
    }

    public void makeItem(String fileName) {
        if (this.activeHandler != null) {
            Package activePackage = null;
            if (this.activeHandler instanceof PackageContextProvider) {
                activePackage = ((PackageContextProvider)((Object)this.activeHandler)).getPackage();
            }
            this.activeHandler.create(activePackage, fileName, this);
        }
    }

    public void complete() {
        this.view.hide();
    }

    private String getActiveHandlerDescription() {
        if (this.activeHandler != null) {
            return this.activeHandler.getDescription();
        }
        return "";
    }

    public static interface View
    extends UberView<NewResourcePresenter> {
        public void show();

        public void hide();

        public void setActiveHandler(NewResourceHandler var1);

        public void setTitle(String var1);
    }
}

