/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.base.InlineLabel;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.resources.i18n.NewItemPopupConstants;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

@ApplicationScoped
public class NewResourceView
extends BaseModal
implements NewResourcePresenter.View {
    private static NewResourceViewBinder uiBinder = (NewResourceViewBinder)GWT.create(NewResourceViewBinder.class);
    private NewResourcePresenter presenter;
    private final Command okCommand = new Command(){

        public void execute() {
            NewResourceView.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            NewResourceView.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);
    @UiField
    ControlGroup fileNameGroup;
    @UiField
    InlineLabel fileTypeLabel;
    @UiField
    TextBox fileNameTextBox;
    @UiField
    HelpInline fileNameHelpInline;
    @UiField
    ControlGroup handlerExtensionsGroup;
    @UiField
    VerticalPanel handlerExtensions;

    public NewResourceView() {
        this.footer.enableOkButton(true);
        this.add((Widget)uiBinder.createAndBindUi(this));
        this.add((Widget)this.footer);
    }

    public void init(NewResourcePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void show() {
        this.fileNameTextBox.setText("");
        this.fileNameGroup.setType(ControlGroupType.NONE);
        this.fileNameHelpInline.setText("");
        super.show();
    }

    @Override
    public void setActiveHandler(NewResourceHandler handler) {
        List<Pair<String, ? extends IsWidget>> extensions = handler.getExtensions();
        boolean showExtensions = extensions != null && !extensions.isEmpty();
        this.fileTypeLabel.setText(handler.getDescription());
        this.handlerExtensions.clear();
        this.handlerExtensionsGroup.getElement().getStyle().setDisplay(showExtensions ? Style.Display.BLOCK : Style.Display.NONE);
        if (showExtensions) {
            for (Pair<String, ? extends IsWidget> extension : extensions) {
                ControlGroup cg = new ControlGroup();
                cg.add((IsWidget)extension.getK2());
                this.handlerExtensions.add((Widget)cg);
            }
        }
    }

    private void onOKButtonClick() {
        final String fileName = this.fileNameTextBox.getText();
        if (fileName == null || fileName.trim().isEmpty()) {
            this.fileNameGroup.setType(ControlGroupType.ERROR);
            this.fileNameHelpInline.setText(NewItemPopupConstants.INSTANCE.fileNameIsMandatory());
            return;
        }
        this.presenter.validate(fileName, new ValidatorWithReasonCallback(){

            public void onSuccess() {
                NewResourceView.this.fileNameGroup.setType(ControlGroupType.NONE);
                NewResourceView.this.presenter.makeItem(fileName);
            }

            public void onFailure() {
                NewResourceView.this.fileNameGroup.setType(ControlGroupType.ERROR);
            }

            public void onFailure(String reason) {
                NewResourceView.this.fileNameGroup.setType(ControlGroupType.ERROR);
                NewResourceView.this.fileNameHelpInline.setText(reason);
            }
        });
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    static interface NewResourceViewBinder
    extends UiBinder<Widget, NewResourceView> {
    }
}

