/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.google.gwt.core.client.Callback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;

@ApplicationScoped
public class NewResourcesMenu {
    @Inject
    private SyncBeanManager iocBeanManager;
    @Inject
    private NewResourcePresenter newResourcePresenter;
    private final List<MenuItem> items = new ArrayList<MenuItem>();
    private boolean hasProjectMenuItem = false;
    private final Map<NewResourceHandler, MenuItem> newResourceHandlers = new HashMap<NewResourceHandler, MenuItem>();

    @PostConstruct
    public void setup() {
        Collection handlerBeans = this.iocBeanManager.lookupBeans(NewResourceHandler.class);
        MenuItem projectMenuItem = null;
        if (handlerBeans.size() > 0) {
            for (IOCBeanDef handlerBean : handlerBeans) {
                final NewResourceHandler activeHandler = (NewResourceHandler)handlerBean.getInstance();
                boolean isProjectMenuItem = activeHandler.getClass().getName().contains("NewProjectHandler");
                String description = activeHandler.getDescription();
                MenuItem menuItem = (MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)description).respondsWith(new Command(){

                    public void execute() {
                        NewResourcesMenu.this.newResourcePresenter.show(activeHandler);
                    }
                })).endMenu()).build().getItems().get(0);
                this.newResourceHandlers.put(activeHandler, menuItem);
                if (!isProjectMenuItem) {
                    this.items.add(menuItem);
                    continue;
                }
                projectMenuItem = menuItem;
            }
        }
        Collections.sort(this.items, new Comparator<MenuItem>(){

            @Override
            public int compare(MenuItem o1, MenuItem o2) {
                return o1.getCaption().compareToIgnoreCase(o2.getCaption());
            }
        });
        if (projectMenuItem != null) {
            this.items.add(0, projectMenuItem);
            this.hasProjectMenuItem = true;
        }
    }

    public List<MenuItem> getMenuItems() {
        return this.items;
    }

    public List<MenuItem> getMenuItemsWithoutProject() {
        if (this.hasProjectMenuItem) {
            return this.items.subList(1, this.items.size());
        }
        return this.items;
    }

    public void onProjectContextChanged(@Observes ProjectContextChangeEvent event) {
        ProjectContext context = new ProjectContext();
        context.setActiveOrganizationalUnit(event.getOrganizationalUnit());
        context.setActiveRepository(event.getRepository());
        context.setActiveProject(event.getProject());
        context.setActivePackage(event.getPackage());
        this.enableNewResourceHandlers(context);
    }

    private void enableNewResourceHandlers(ProjectContext context) {
        for (Map.Entry<NewResourceHandler, MenuItem> e : this.newResourceHandlers.entrySet()) {
            NewResourceHandler handler = e.getKey();
            final MenuItem menuItem = e.getValue();
            handler.acceptContext(context, new Callback<Boolean, Void>(){

                public void onFailure(Void reason) {
                }

                public void onSuccess(Boolean result) {
                    if (result != null) {
                        menuItem.setEnabled(result.booleanValue());
                    }
                }
            });
        }
    }
}

