/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.github.gwtbootstrap.client.ui.ListBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;

public class PackageListBox
extends ListBox {
    @Inject
    protected Caller<KieProjectService> projectService;
    private final List<Package> packages = new ArrayList<Package>();

    public void setContext(ProjectContext context, final boolean includeDefaultPackage) {
        this.clear();
        this.packages.clear();
        this.setEnabled(true);
        if (context.getActiveProject() == null) {
            this.addItem(CommonConstants.INSTANCE.ItemUndefinedPath());
            this.setEnabled(false);
            return;
        }
        final Package activePackage = context.getActivePackage();
        ((KieProjectService)this.projectService.call((RemoteCallback)new RemoteCallback<Set<Package>>(){

            public void callback(Set<Package> pkgs) {
                ArrayList<Package> sortedPackages = new ArrayList<Package>();
                sortedPackages.addAll(pkgs);
                Collections.sort(sortedPackages, new Comparator<Package>(){

                    @Override
                    public int compare(Package p1, Package p2) {
                        return p1.getCaption().compareTo(p2.getCaption());
                    }
                });
                if (!includeDefaultPackage) {
                    sortedPackages.remove(0);
                }
                if (sortedPackages.size() == 0) {
                    PackageListBox.this.addItem(CommonConstants.INSTANCE.ItemUndefinedPath());
                    PackageListBox.this.setEnabled(false);
                    return;
                }
                int selectedIndex = -1;
                for (Package pkg : sortedPackages) {
                    PackageListBox.this.addItem(pkg.getCaption());
                    PackageListBox.this.packages.add(pkg);
                    if (!pkg.equals((Object)activePackage)) continue;
                    selectedIndex = PackageListBox.this.packages.indexOf(pkg);
                }
                if (selectedIndex != -1) {
                    PackageListBox.this.setSelectedIndex(selectedIndex);
                } else {
                    PackageListBox.this.setSelectedIndex(0);
                }
            }
        })).resolvePackages(context.getActiveProject());
    }

    public Package getSelectedPackage() {
        if (this.packages.size() == 0) {
            return null;
        }
        int selectedIndex = this.getSelectedIndex();
        return selectedIndex < 0 && selectedIndex >= this.packages.size() ? null : this.packages.get(selectedIndex);
    }
}

