/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.ruleselector;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.ruleselector.RuleSelectorDropdown;

public class RuleSelector
extends Composite
implements HasValueChangeHandlers<String> {
    private final HorizontalPanel panel = new HorizontalPanel();
    private final InlineLabel ruleNamePanel = new InlineLabel();
    private final RuleSelectorDropdown ruleSelectorDropdown = new RuleSelectorDropdown();
    private static final String NONE_SELECTED = CommonConstants.INSTANCE.NoneSelected();

    public RuleSelector() {
        this.ruleNamePanel.setText(NONE_SELECTED);
        this.ruleSelectorDropdown.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String ruleName = (String)event.getValue();
                if (ruleName.isEmpty()) {
                    RuleSelector.this.ruleNamePanel.setText(NONE_SELECTED);
                } else {
                    RuleSelector.this.ruleNamePanel.setText(ruleName);
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)RuleSelector.this, (Object)ruleName);
            }
        });
        this.panel.add((Widget)this.ruleNamePanel);
        this.panel.add((Widget)this.ruleSelectorDropdown);
        this.initWidget((Widget)this.panel);
        this.getElement().setAttribute("data-uf-lock", "true");
    }

    public void setRuleNames(Collection<String> ruleNames, String exclude) {
        this.ruleSelectorDropdown.setRuleNames(RuleSelector.exclude(ruleNames, exclude));
    }

    public void setRuleNames(Collection<String> ruleNames) {
        this.ruleSelectorDropdown.setRuleNames(ruleNames);
    }

    private static Collection<String> exclude(Collection<String> ruleNames, String exclude) {
        ArrayList<String> result = new ArrayList<String>();
        for (String ruleName : ruleNames) {
            if (ruleName.equals(exclude)) continue;
            result.add(ruleName);
        }
        return result;
    }

    public String getRuleName() {
        if (this.ruleNamePanel.getText() != null && !this.ruleNamePanel.getText().equals(NONE_SELECTED)) {
            return "";
        }
        return this.ruleNamePanel.getText();
    }

    public void setRuleName(String ruleName) {
        if (ruleName != null && !ruleName.isEmpty()) {
            this.ruleNamePanel.setText(ruleName);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }
}

