/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.tables;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonCell;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.ProvidesKey;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.paging.AbstractPathPageRow;

public abstract class AbstractPathPagedTable<T extends AbstractPathPageRow>
extends Composite {
    protected MultiSelectionModel<T> selectionModel;
    protected final PagedTable dataGrid;
    private final ProvidesKey<T> providesKey = new ProvidesKey<T>(){

        public Object getKey(T row) {
            return row.getPath();
        }
    };

    public AbstractPathPagedTable(int pageSize) {
        this.dataGrid = new PagedTable(pageSize, this.providesKey);
        this.selectionModel = new MultiSelectionModel(this.providesKey);
        this.dataGrid.setSelectionModel(this.selectionModel);
        Column selectionColumn = new Column<T, Boolean>((Cell)new CheckboxCell(true, true)){

            public Boolean getValue(T object) {
                return AbstractPathPagedTable.this.dataGrid.getSelectionModel().isSelected(object);
            }
        };
        selectionColumn.setFieldUpdater(new FieldUpdater<T, Boolean>(){

            public void update(int index, T object, Boolean value) {
                AbstractPathPagedTable.this.dataGrid.getSelectionModel().setSelected(object, value.booleanValue());
            }
        });
        this.dataGrid.addColumn(selectionColumn, "");
        this.addAncillaryColumns();
        TextColumn uriColumn = new TextColumn<T>(){

            public String getValue(T row) {
                return row.getPath().toURI();
            }
        };
        this.dataGrid.addColumn((Column)uriColumn, CommonConstants.INSTANCE.AbstractTableFileURI(), false);
        Column openColumn = new Column<T, String>((Cell)new ButtonCell(ButtonSize.SMALL)){

            public String getValue(T row) {
                return CommonConstants.INSTANCE.AbstractTableOpen();
            }
        };
        openColumn.setFieldUpdater(new FieldUpdater<T, String>(){

            public void update(int index, T row, String value) {
                AbstractPathPagedTable.this.getPlaceManager().goTo(row.getPath());
            }
        });
        this.dataGrid.addColumn(openColumn, CommonConstants.INSTANCE.AbstractTableOpen());
        Button refreshButton = new Button();
        refreshButton.setIcon(IconType.REFRESH);
        refreshButton.setTitle(CommonConstants.INSTANCE.Refresh());
        refreshButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractPathPagedTable.this.dataGrid.refresh();
            }
        });
        this.dataGrid.getToolbar().add((Widget)refreshButton);
        Button openSelectedButton = new Button(CommonConstants.INSTANCE.AbstractTableOpenSelected());
        openSelectedButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Set selectedSet = AbstractPathPagedTable.this.selectionModel.getSelectedSet();
                for (AbstractPathPageRow selected : selectedSet) {
                    AbstractPathPagedTable.this.getPlaceManager().goTo(selected.getPath());
                }
            }
        });
        this.dataGrid.getToolbar().add((Widget)openSelectedButton);
        this.initWidget((Widget)this.dataGrid);
    }

    protected abstract void addAncillaryColumns();

    public Collection<Path> getSelectedRowPaths() {
        Set selectedRows = this.selectionModel.getSelectedSet();
        if (selectedRows.size() == 0) {
            return null;
        }
        ArrayList<Path> paths = new ArrayList<Path>(selectedRows.size());
        for (AbstractPathPageRow row : selectedRows) {
            paths.add(row.getPath());
        }
        return paths;
    }

    public void refresh() {
        this.selectionModel.clear();
        this.dataGrid.setVisibleRangeAndClearData(this.dataGrid.getVisibleRange(), true);
    }

    public void setDataProvider(AsyncDataProvider<T> dataProvider) {
        dataProvider.addDataDisplay((HasData)this.dataGrid);
    }

    private PlaceManager getPlaceManager() {
        return (PlaceManager)IOC.getBeanManager().lookupBean(PlaceManager.class, new Annotation[0]).getInstance();
    }
}

