/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.github.gwtbootstrap.client.ui.Form;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.FormElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.guvnor.common.services.shared.file.upload.FileOperation;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

public class AttachmentFileWidget
extends Composite {
    private final Form form = new Form();
    private FileUpload up;
    private final HorizontalPanel fields = new HorizontalPanel();
    private final TextBox fieldFilePath = this.getHiddenField("attachmentPath", "");
    private final TextBox fieldFileName = this.getHiddenField("fileName", "");
    private final TextBox fieldFileFullPath = this.getHiddenField("attachmentFullPath", "");
    private final TextBox fieldFileOperation = this.getHiddenField("operation", "");
    private com.google.gwt.user.client.Command successCallback;
    private com.google.gwt.user.client.Command errorCallback;
    private String[] validFileExtensions;
    private ClickHandler uploadButtonClickHanlder;

    public AttachmentFileWidget() {
        this.setup(false);
    }

    public AttachmentFileWidget(String[] validFileExtensions) {
        this.setup(false);
        this.setAccept(validFileExtensions);
    }

    public AttachmentFileWidget(boolean addFileUpload) {
        this.setup(addFileUpload);
    }

    public AttachmentFileWidget(String[] validFileExtensions, boolean addFileUpload) {
        this.setup(addFileUpload);
        this.setAccept(validFileExtensions);
    }

    private void setup(boolean addFileUpload) {
        this.up = new FileUpload(new Command(){

            public void execute() {
                AttachmentFileWidget.this.uploadButtonClickHanlder.onClick(null);
            }
        }, addFileUpload);
        this.up.setName("fileUploadElement");
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        FormElement.as((Element)this.form.getElement()).setAcceptCharset("UTF-8");
        Hidden field = new Hidden();
        field.setName("utf8char");
        field.setValue("\u8482");
        this.form.add((Widget)field);
        this.form.addSubmitHandler(new Form.SubmitHandler(){

            public void onSubmit(Form.SubmitEvent event) {
                String fileName = AttachmentFileWidget.this.up.getFilename();
                if (fileName == null || "".equals(fileName)) {
                    Window.alert((String)org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants.INSTANCE.UploadSelectAFile());
                    event.cancel();
                    AttachmentFileWidget.this.executeCallback(AttachmentFileWidget.this.errorCallback);
                    return;
                }
                if (AttachmentFileWidget.this.validFileExtensions != null && AttachmentFileWidget.this.validFileExtensions.length != 0) {
                    boolean isValid = false;
                    for (String extension : AttachmentFileWidget.this.validFileExtensions) {
                        if (!fileName.endsWith(extension)) continue;
                        isValid = true;
                        break;
                    }
                    if (!isValid) {
                        Window.alert((String)(org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants.INSTANCE.UploadFileTypeNotSupported() + "\n\n" + org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants.INSTANCE.UploadFileTypeSupportedExtensions0(this.makeValidFileExtensionsText())));
                        event.cancel();
                        AttachmentFileWidget.this.executeCallback(AttachmentFileWidget.this.errorCallback);
                        return;
                    }
                }
            }

            private String makeValidFileExtensionsText() {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < AttachmentFileWidget.this.validFileExtensions.length; ++i) {
                    sb.append("\"").append(AttachmentFileWidget.this.validFileExtensions[i]).append(i < AttachmentFileWidget.this.validFileExtensions.length - 1 ? "\", " : "\"");
                }
                return sb.toString();
            }
        });
        this.form.addSubmitCompleteHandler(new Form.SubmitCompleteHandler(){

            public void onSubmitComplete(Form.SubmitCompleteEvent event) {
                if ("OK".equalsIgnoreCase(event.getResults())) {
                    AttachmentFileWidget.this.executeCallback(AttachmentFileWidget.this.successCallback);
                    Window.alert((String)org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants.INSTANCE.UploadSuccess());
                } else {
                    AttachmentFileWidget.this.executeCallback(AttachmentFileWidget.this.errorCallback);
                    if (event.getResults().contains("org.uberfire.java.nio.file.FileAlreadyExistsException")) {
                        Window.alert((String)CommonConstants.INSTANCE.ExceptionFileAlreadyExists0(AttachmentFileWidget.this.fieldFileName.getText()));
                    } else if (event.getResults().contains("DecisionTableParseException")) {
                        Window.alert((String)org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants.INSTANCE.UploadGenericError());
                    } else {
                        Window.alert((String)CommonConstants.INSTANCE.ExceptionGeneric0(event.getResults()));
                    }
                }
                AttachmentFileWidget.this.reset();
            }
        });
        this.fields.add((Widget)this.up);
        this.fields.add((Widget)this.fieldFilePath);
        this.fields.add((Widget)this.fieldFileName);
        this.fields.add((Widget)this.fieldFileFullPath);
        this.fields.add((Widget)this.fieldFileOperation);
        this.form.add((Widget)this.fields);
        this.initWidget((Widget)this.form);
    }

    private void executeCallback(com.google.gwt.user.client.Command callback) {
        if (callback == null) {
            return;
        }
        callback.execute();
    }

    public void reset() {
        this.form.reset();
    }

    public void submit(Path context, String fileName, String targetUrl, com.google.gwt.user.client.Command successCallback, com.google.gwt.user.client.Command errorCallback) {
        this.successCallback = successCallback;
        this.errorCallback = errorCallback;
        this.fieldFileName.setText(fileName);
        this.fieldFilePath.setText(context.toURI());
        this.fieldFileOperation.setText(FileOperation.CREATE.toString());
        this.fieldFileFullPath.setText("");
        this.form.setAction(targetUrl);
        this.form.submit();
    }

    public void submit(Path path, String targetUrl, com.google.gwt.user.client.Command successCallback, com.google.gwt.user.client.Command errorCallback) {
        this.successCallback = successCallback;
        this.errorCallback = errorCallback;
        this.fieldFileOperation.setText(FileOperation.UPDATE.toString());
        this.fieldFileFullPath.setText(path.toURI());
        this.fieldFileName.setText("");
        this.fieldFilePath.setText("");
        this.form.setAction(targetUrl);
        this.form.submit();
    }

    private void setAccept(String[] validFileExtensions) {
        this.validFileExtensions = validFileExtensions;
        InputElement element = (InputElement)this.up.getElement().cast();
        element.setAccept(this.makeAcceptString(validFileExtensions));
    }

    private String makeAcceptString(String[] validFileExtensions) {
        if (validFileExtensions == null || validFileExtensions.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String fileExtension : validFileExtensions) {
            sb.append(fileExtension).append(",");
        }
        sb.substring(0, sb.length() - 1);
        return sb.toString();
    }

    private TextBox getHiddenField(String name, String value) {
        TextBox t = new TextBox();
        t.setName(name);
        t.setText(value);
        t.setVisible(false);
        return t;
    }

    public void addClickHandler(ClickHandler clickHandler) {
        this.uploadButtonClickHanlder = clickHandler;
    }

    public void setEnabled(boolean b) {
        this.up.setEnabled(b);
    }
}

