/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.widget.DatePickerPopUp;
import org.uberfire.ext.widgets.common.client.common.ValueChanged;

abstract class DatePicker
extends Composite {
    protected DatePickerPopUp datePickerPopUp;
    protected Panel panel = new HorizontalPanel();
    protected TextBox textWidget = new TextBox();
    protected String visualFormat = "";
    protected static final String defaultFormat = ApplicationPreferences.getDroolsDateFormat();
    protected DateTimeFormat visualFormatFormatter = null;
    protected List<ValueChanged> valueChangeds = new ArrayList<ValueChanged>();

    DatePicker() {
    }

    protected void solveVisualFormat(String visualFormat) {
        if (visualFormat == null || visualFormat.equals("default") || visualFormat.equals("")) {
            visualFormat = defaultFormat;
        }
        this.visualFormat = visualFormat;
    }

    public String getVisualFormat() {
        return this.visualFormat;
    }

    public String getDateString() {
        Date date = null;
        String t = this.textWidget.getText();
        try {
            date = this.visualFormatFormatter.parse(t);
            DateTimeFormat formatter = DateTimeFormat.getFormat((String)defaultFormat);
            return formatter.format(date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected Date fillDate() {
        Date date = this.visualFormatFormatter.parse(this.textWidget.getText());
        date.setYear(Integer.parseInt(this.datePickerPopUp.years.getItemText(this.datePickerPopUp.years.getSelectedIndex())) - 1900);
        date.setMonth(this.datePickerPopUp.months.getSelectedIndex());
        date.setDate(this.datePickerPopUp.dates.getSelectedIndex() + 1);
        if (this.datePickerPopUp.showTime) {
            date.setHours(this.datePickerPopUp.hours.getSelectedIndex());
            date.setMinutes(this.datePickerPopUp.minutes.getSelectedIndex());
        }
        return date;
    }

    public Date getDate() throws IllegalArgumentException {
        if (this.textWidget.getText() == null || "".equals(this.textWidget.getText())) {
            return null;
        }
        return this.visualFormatFormatter.parse(this.textWidget.getText().trim());
    }

    protected void valueChanged() {
        for (ValueChanged changed : this.valueChangeds) {
            changed.valueChanged(this.getDateString());
        }
    }

    public void addValueChanged(ValueChanged listener) {
        this.valueChangeds.add(listener);
    }

    public void removeValueChanged(ValueChanged listener) {
        this.valueChangeds.remove(listener);
    }
}

