/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.widget.DatePicker;
import org.kie.workbench.common.widgets.client.widget.DatePickerPopUp;

public class DatePickerLabel
extends DatePicker {
    protected Label labelWidget = new Label();

    public DatePickerLabel(String selectedDate) {
        this(selectedDate, defaultFormat);
    }

    public DatePickerLabel(String selectedDate, String visualFormat) {
        this.solveVisualFormat(visualFormat);
        this.visualFormatFormatter = DateTimeFormat.getFormat((String)this.visualFormat);
        this.datePickerPopUp = new DatePickerPopUp(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    Date date = DatePickerLabel.this.fillDate();
                    DatePickerLabel.this.textWidget.setText(DatePickerLabel.this.visualFormatFormatter.format(date));
                    DatePickerLabel.this.labelWidget.setText(DatePickerLabel.this.textWidget.getText());
                    DatePickerLabel.this.valueChanged();
                    DatePickerLabel.this.panel.clear();
                    DatePickerLabel.this.panel.add((Widget)DatePickerLabel.this.labelWidget);
                    DatePickerLabel.this.datePickerPopUp.hide();
                }
                catch (Exception e) {
                    Window.alert((String)CommonConstants.INSTANCE.InvalidDateFormatMessage());
                }
            }
        }, this.visualFormatFormatter);
        this.labelWidget.setStyleName("form-field");
        this.labelWidget.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DatePickerLabel.this.panel.clear();
                DatePickerLabel.this.panel.add((Widget)DatePickerLabel.this.textWidget);
                DatePickerLabel.this.datePickerPopUp.setPopupPosition(DatePickerLabel.this.textWidget.getAbsoluteLeft(), DatePickerLabel.this.textWidget.getAbsoluteTop() + 20);
                DatePickerLabel.this.datePickerPopUp.setDropdowns(DatePickerLabel.this.visualFormatFormatter, DatePickerLabel.this.textWidget.getText());
                DatePickerLabel.this.datePickerPopUp.show();
            }
        });
        try {
            DateTimeFormat formatter = DateTimeFormat.getFormat((String)defaultFormat);
            Date date = formatter.parse(selectedDate);
            selectedDate = this.visualFormatFormatter.format(date);
        }
        catch (Exception e) {
            selectedDate = this.visualFormatFormatter.format(new Date());
        }
        if (selectedDate != null && !selectedDate.equals("")) {
            this.textWidget.setText(selectedDate);
            this.labelWidget.setText(selectedDate);
        }
        this.textWidget.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                TextBox box = (TextBox)event.getSource();
                DatePickerLabel.this.textWidget.setText(box.getText());
                DatePickerLabel.this.labelWidget.setText(box.getText());
                DatePickerLabel.this.valueChanged();
                DatePickerLabel.this.panel.clear();
                DatePickerLabel.this.panel.add((Widget)DatePickerLabel.this.labelWidget);
                DatePickerLabel.this.datePickerPopUp.hide();
            }
        });
        this.panel.add((Widget)this.labelWidget);
        this.initWidget((Widget)this.panel);
    }
}

