/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;

public class DatePickerPopUp
extends PopupPanel {
    private Label timeColonLabel = new Label(":");
    private Label timeHyphenLabel = new Label(" - ");
    protected boolean showTime = false;
    protected ListBox years = new ListBox();
    protected ListBox months = new ListBox();
    protected ListBox dates = new ListBox();
    protected ListBox hours = new ListBox();
    protected ListBox minutes = new ListBox();

    public DatePickerPopUp(ClickHandler okClickHandler, DateTimeFormat formatter) {
        int year;
        int i;
        this.setGlassEnabled(true);
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        Date now = new Date();
        for (i = year = now.getYear() + 1900 - 50; i < year + 100; ++i) {
            this.years.addItem(Integer.toString(i));
        }
        this.years.setSelectedIndex(50);
        horizontalPanel.add((Widget)this.years);
        this.months.addItem(CommonConstants.INSTANCE.January());
        this.months.addItem(CommonConstants.INSTANCE.February());
        this.months.addItem(CommonConstants.INSTANCE.March());
        this.months.addItem(CommonConstants.INSTANCE.April());
        this.months.addItem(CommonConstants.INSTANCE.May());
        this.months.addItem(CommonConstants.INSTANCE.June());
        this.months.addItem(CommonConstants.INSTANCE.July());
        this.months.addItem(CommonConstants.INSTANCE.August());
        this.months.addItem(CommonConstants.INSTANCE.September());
        this.months.addItem(CommonConstants.INSTANCE.October());
        this.months.addItem(CommonConstants.INSTANCE.November());
        this.months.addItem(CommonConstants.INSTANCE.December());
        this.months.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                DatePickerPopUp.this.fillDates();
            }
        });
        horizontalPanel.add((Widget)this.months);
        this.fillDates();
        horizontalPanel.add((Widget)this.dates);
        this.showTime = this.hasTime(formatter);
        if (this.showTime) {
            for (i = 0; i < 24; ++i) {
                this.hours.addItem(Integer.toString(i));
            }
            horizontalPanel.add((Widget)this.timeHyphenLabel);
            horizontalPanel.add((Widget)this.hours);
            for (i = 0; i < 60; ++i) {
                this.minutes.addItem(Integer.toString(i));
            }
            horizontalPanel.add((Widget)this.timeColonLabel);
            horizontalPanel.add((Widget)this.minutes);
        }
        Button okButton = new Button(CommonConstants.INSTANCE.OK());
        okButton.addClickHandler(okClickHandler);
        horizontalPanel.add((Widget)okButton);
        this.add((Widget)horizontalPanel);
    }

    private boolean hasTime(DateTimeFormat formatter) {
        return formatter.getPattern().contains("h") || formatter.getPattern().contains("H") || formatter.getPattern().contains("k") || formatter.getPattern().contains("K");
    }

    private void setTimeVisible(boolean visible) {
        this.hours.setVisible(visible);
        this.minutes.setVisible(visible);
        this.timeHyphenLabel.setVisible(visible);
        this.timeColonLabel.setVisible(visible);
    }

    public void setDropdowns(DateTimeFormat formatter, String text) {
        Date date;
        try {
            date = formatter.parse(text);
        }
        catch (Exception e) {
            date = new Date();
        }
        this.years.clear();
        int year = date.getYear() + 1900 - 50;
        for (int i = 0; i < 100; ++i) {
            this.years.addItem(Integer.toString(year));
            if (year == date.getYear() + 1900) {
                this.years.setSelectedIndex(i);
            }
            ++year;
        }
        this.months.setSelectedIndex(date.getMonth());
        this.dates.setSelectedIndex(date.getDate() - 1);
        this.setTimeVisible(this.showTime);
        if (this.showTime) {
            this.hours.setSelectedIndex(date.getHours());
            this.minutes.setSelectedIndex(date.getMinutes());
        }
    }

    private void fillDates() {
        this.setVisible(false);
        this.dates.clear();
        int days = this.daysInMonth(this.months.getSelectedIndex() + 1);
        for (int i = 1; i <= days; ++i) {
            this.dates.addItem(Integer.toString(i));
        }
        this.setVisible(true);
    }

    private int daysInMonth(int month) {
        switch (month) {
            case 2: {
                return 29;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }
}

