/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.ListBox;
import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.jboss.errai.bus.client.api.BusErrorCallback;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.enums.EnumDropdownService;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.util.ConstraintValueHelper;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

public class EnumDropDownUtilities {
    public void setDropDownData(final String value, final DropDownData dropData, final boolean isMultipleSelect, final Path resource, final ListBox listBox) {
        if (dropData != null && dropData.getFixedList() == null && dropData.getQueryExpression() != null) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    BusyPopup.showMessage((String)CommonConstants.INSTANCE.RefreshingList());
                    ((EnumDropdownService)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<String[]>(){

                        public void callback(String[] response) {
                            BusyPopup.close();
                            if (response.length == 0) {
                                response = new String[]{CommonConstants.INSTANCE.UnableToLoadList()};
                            }
                            EnumDropDownUtilities.this.fillDropDown(value, response, isMultipleSelect, listBox);
                        }
                    }, (BusErrorCallback)new BusErrorCallback(){

                        public boolean error(Message message, Throwable throwable) {
                            BusyPopup.close();
                            return false;
                        }
                    }, EnumDropdownService.class)).loadDropDownExpression(resource, dropData.getValuePairs(), dropData.getQueryExpression());
                }
            });
        } else {
            this.fillDropDown(value, dropData, isMultipleSelect, listBox);
        }
    }

    private void fillDropDown(String value, DropDownData dropData, boolean isMultipleSelect, ListBox listBox) {
        if (dropData == null) {
            this.fillDropDown(value, new String[0], isMultipleSelect, listBox);
        } else {
            this.fillDropDown(value, dropData.getFixedList(), isMultipleSelect, listBox);
        }
    }

    private void fillDropDown(String value, String[] enumeratedValues, boolean isMultipleSelect, ListBox listBox) {
        String currentValue;
        listBox.clear();
        int selectedIndexOffset = this.addItems(listBox);
        boolean selected = false;
        HashSet<String> currentValues = new HashSet<String>();
        String trimmedCurrentValue = currentValue = value;
        if (isMultipleSelect && trimmedCurrentValue != null) {
            trimmedCurrentValue = currentValue.replace("\"", "");
            trimmedCurrentValue = trimmedCurrentValue.replace("(", "");
            trimmedCurrentValue = trimmedCurrentValue.replace(")", "");
            for (String val : Arrays.asList(trimmedCurrentValue.split(","))) {
                currentValues.add(val.trim());
            }
        } else {
            currentValues.add(currentValue);
        }
        for (int i = 0; i < enumeratedValues.length; ++i) {
            String val;
            String v = enumeratedValues[i];
            if (v.indexOf(61) > 0) {
                String[] splut = ConstraintValueHelper.splitValue(v);
                String realValue = splut[0];
                String display = splut[1];
                val = realValue;
                listBox.addItem(display, realValue);
            } else {
                listBox.addItem(v);
                val = v;
            }
            if (currentValue == null || !currentValues.contains(val)) continue;
            listBox.setItemSelected(i + selectedIndexOffset, true);
            selected = true;
        }
        if (!selected) {
            this.selectItem(listBox);
        }
    }

    protected int addItems(ListBox listBox) {
        return 0;
    }

    protected void selectItem(ListBox listBox) {
    }
}

