/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.PackageContextProvider;
import org.kie.workbench.common.widgets.client.handlers.PackageListBox;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.type.ResourceTypeDefinition;

public abstract class DefaultNewResourceHandler
implements NewResourceHandler,
PackageContextProvider {
    protected final List<Pair<String, ? extends IsWidget>> extensions = new LinkedList<Pair<String, ? extends IsWidget>>();
    @Inject
    protected PackageListBox packagesListBox;
    @Inject
    protected ProjectContext context;
    @Inject
    protected Caller<KieProjectService> projectService;
    @Inject
    protected Caller<ValidationService> validationService;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Event<NotificationEvent> notificationEvent;
    @Inject
    private BusyIndicatorView busyIndicatorView;

    DefaultNewResourceHandler(PackageListBox packagesListBox, ProjectContext context, Caller<KieProjectService> projectService, Caller<ValidationService> validationService, PlaceManager placeManager, Event<NotificationEvent> notificationEvent, BusyIndicatorView busyIndicatorView) {
        this.packagesListBox = packagesListBox;
        this.context = context;
        this.projectService = projectService;
        this.validationService = validationService;
        this.placeManager = placeManager;
        this.notificationEvent = notificationEvent;
        this.busyIndicatorView = busyIndicatorView;
    }

    public DefaultNewResourceHandler() {
    }

    @PostConstruct
    private void setupExtensions() {
        this.extensions.add((Pair<String, ? extends IsWidget>)Pair.newPair((Object)CommonConstants.INSTANCE.ItemPathSubheading(), (Object)((Object)this.packagesListBox)));
    }

    @Override
    public List<Pair<String, ? extends IsWidget>> getExtensions() {
        this.packagesListBox.setContext(this.context, true);
        return this.extensions;
    }

    @Override
    public void validate(final String baseFileName, final ValidatorWithReasonCallback callback) {
        if (this.packagesListBox.getSelectedPackage() == null) {
            ErrorPopup.showMessage((String)CommonConstants.INSTANCE.MissingPath());
            callback.onFailure();
            return;
        }
        String fileName = this.buildFileName(baseFileName, this.getResourceType());
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean response) {
                if (Boolean.TRUE.equals(response)) {
                    callback.onSuccess();
                } else {
                    callback.onFailure(CommonConstants.INSTANCE.InvalidFileName0(baseFileName));
                }
            }
        })).isFileNameValid(fileName);
    }

    @Override
    public void acceptContext(ProjectContext context, Callback<Boolean, Void> callback) {
        if (context == null) {
            callback.onSuccess((Object)false);
        } else {
            callback.onSuccess((Object)(context.getActiveProject() != null ? 1 : 0));
        }
    }

    @Override
    public Command getCommand(final NewResourcePresenter newResourcePresenter) {
        return new Command(){

            public void execute() {
                newResourcePresenter.show(DefaultNewResourceHandler.this);
            }
        };
    }

    @Override
    public Package getPackage() {
        return this.packagesListBox.getSelectedPackage();
    }

    protected String buildFileName(String baseFileName, ResourceTypeDefinition resourceType) {
        String extension;
        String suffix = resourceType.getSuffix();
        String prefix = resourceType.getPrefix();
        String string = extension = suffix != null && !"".equals(suffix) ? "." + resourceType.getSuffix() : "";
        if (baseFileName.endsWith(extension)) {
            return prefix + baseFileName;
        }
        return prefix + baseFileName + extension;
    }

    protected void notifySuccess() {
        this.notificationEvent.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCreatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
    }

    protected RemoteCallback<Path> getSuccessCallback(final NewResourcePresenter presenter) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                DefaultNewResourceHandler.this.busyIndicatorView.hideBusyIndicator();
                presenter.complete();
                DefaultNewResourceHandler.this.notifySuccess();
                PathPlaceRequest place = new PathPlaceRequest(path);
                DefaultNewResourceHandler.this.placeManager.goTo((PlaceRequest)place);
            }
        };
    }

    @Override
    public boolean canCreate() {
        return true;
    }
}

