/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.google.gwt.core.client.Callback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;

@ApplicationScoped
public class NewResourcesMenu {
    private SyncBeanManager iocBeanManager;
    private NewResourcePresenter newResourcePresenter;
    private final List<MenuItem> items = new ArrayList<MenuItem>();
    private final Map<NewResourceHandler, MenuItem> newResourceHandlers = new HashMap<NewResourceHandler, MenuItem>();
    private MenuItem projectMenuItem;

    public NewResourcesMenu() {
    }

    @Inject
    public NewResourcesMenu(SyncBeanManager iocBeanManager, NewResourcePresenter newResourcePresenter) {
        this.iocBeanManager = iocBeanManager;
        this.newResourcePresenter = newResourcePresenter;
    }

    @PostConstruct
    public void setup() {
        this.addNewResourceHandlers();
        this.sortMenuItemsByCaption();
        this.addProjectMenuItem();
    }

    private void addNewResourceHandlers() {
        Collection handlerBeans = this.iocBeanManager.lookupBeans(NewResourceHandler.class);
        for (IOCBeanDef handlerBean : handlerBeans) {
            this.addMenuItem((NewResourceHandler)handlerBean.getInstance());
        }
    }

    private void addMenuItem(NewResourceHandler newResourceHandler) {
        if (newResourceHandler.canCreate()) {
            MenuItem menuItem = this.getMenuItem(newResourceHandler);
            this.newResourceHandlers.put(newResourceHandler, menuItem);
            if (this.isProjectMenuItem(newResourceHandler)) {
                this.projectMenuItem = menuItem;
            } else {
                this.items.add(menuItem);
            }
        }
    }

    private void addProjectMenuItem() {
        if (this.projectMenuItem != null) {
            this.items.add(0, this.projectMenuItem);
        }
    }

    private void sortMenuItemsByCaption() {
        Collections.sort(this.items, new Comparator<MenuItem>(){

            @Override
            public int compare(MenuItem o1, MenuItem o2) {
                return o1.getCaption().compareToIgnoreCase(o2.getCaption());
            }
        });
    }

    private MenuItem getMenuItem(final NewResourceHandler activeHandler) {
        String description = activeHandler.getDescription();
        return (MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)description).respondsWith(new Command(){

            public void execute() {
                Command command = activeHandler.getCommand(NewResourcesMenu.this.newResourcePresenter);
                command.execute();
            }
        })).endMenu()).build().getItems().get(0);
    }

    private boolean isProjectMenuItem(NewResourceHandler activeHandler) {
        return activeHandler.getClass().getName().contains("NewProjectHandler");
    }

    public List<MenuItem> getMenuItems() {
        return this.items;
    }

    public List<MenuItem> getMenuItemsWithoutProject() {
        if (this.projectMenuItem != null && this.items.contains(this.projectMenuItem)) {
            return this.items.subList(1, this.items.size());
        }
        return this.items;
    }

    public void onProjectContextChanged(@Observes ProjectContextChangeEvent event) {
        ProjectContext context = new ProjectContext();
        context.setActiveOrganizationalUnit(event.getOrganizationalUnit());
        context.setActiveRepository(event.getRepository());
        context.setActiveProject(event.getProject());
        context.setActivePackage(event.getPackage());
        this.enableNewResourceHandlers(context);
    }

    private void enableNewResourceHandlers(ProjectContext context) {
        for (Map.Entry<NewResourceHandler, MenuItem> entry : this.newResourceHandlers.entrySet()) {
            NewResourceHandler handler = entry.getKey();
            final MenuItem menuItem = entry.getValue();
            handler.acceptContext(context, new Callback<Boolean, Void>(){

                public void onFailure(Void reason) {
                }

                public void onSuccess(Boolean result) {
                    if (result != null) {
                        menuItem.setEnabled(result.booleanValue());
                    }
                }
            });
        }
    }
}

