/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Package;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;

@Dependent
public class PackageListBox
extends Composite {
    private SimplePanel panel = new SimplePanel();
    private Select select;
    @Inject
    protected Caller<KieProjectService> projectService;
    private final Map<String, Package> packages = new HashMap<String, Package>();

    public PackageListBox() {
        this.initWidget((Widget)this.panel);
        this.getElement().getStyle().setMarginBottom(15.0, Style.Unit.PX);
    }

    public void setContext(ProjectContext context, final boolean includeDefaultPackage) {
        this.noPackage();
        this.packages.clear();
        if (context.getActiveProject() == null) {
            return;
        }
        final Package activePackage = context.getActivePackage();
        ((KieProjectService)this.projectService.call((RemoteCallback)new RemoteCallback<Set<Package>>(){

            public void callback(Set<Package> pkgs) {
                ArrayList<Package> sortedPackages = new ArrayList<Package>();
                sortedPackages.addAll(pkgs);
                Collections.sort(sortedPackages, new Comparator<Package>(){

                    @Override
                    public int compare(Package p1, Package p2) {
                        return p1.getCaption().compareTo(p2.getCaption());
                    }
                });
                if (!includeDefaultPackage) {
                    sortedPackages.remove(0);
                }
                if (sortedPackages.size() == 0) {
                    return;
                }
                PackageListBox.this.clearSelect();
                for (Package pkg : sortedPackages) {
                    Option option = new Option();
                    option.setText(pkg.getCaption());
                    PackageListBox.this.select.add((Widget)option);
                    PackageListBox.this.packages.put(pkg.getCaption(), pkg);
                    if (!pkg.equals((Object)activePackage)) continue;
                    PackageListBox.this.select.setValue(option);
                }
                PackageListBox.this.select.refresh();
            }
        })).resolvePackages(context.getActiveProject());
    }

    public Package getSelectedPackage() {
        if (this.packages.size() == 0 || this.select == null) {
            return null;
        }
        return this.packages.get(this.select.getValue());
    }

    private void noPackage() {
        this.clearSelect();
        Option option = new Option();
        option.setText(CommonConstants.INSTANCE.ItemUndefinedPath());
        this.select.add((Widget)option);
        this.select.setEnabled(false);
        this.select.refresh();
    }

    private void clearSelect() {
        if (this.select != null) {
            this.select.removeFromParent();
            this.removeSelect((Element)this.select.getElement());
        }
        this.select = new Select();
        this.panel.setWidget((Widget)this.select);
    }

    private native void removeSelect(Element var1);
}

