/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.workitems;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.drools.workbench.models.datamodel.workitems.PortableBooleanParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.workitems.IBindingProvider;
import org.kie.workbench.common.widgets.client.workitems.WorkItemParameterWidget;

public class WorkItemBooleanParameterWidget
extends WorkItemParameterWidget {
    @UiField
    Label parameterName;
    @UiField
    ListBox parameterValues;
    @UiField
    ListBox lstAvailableBindings;
    private static WorkItemBooleanParameterWidgetBinder uiBinder = (WorkItemBooleanParameterWidgetBinder)GWT.create(WorkItemBooleanParameterWidgetBinder.class);

    public WorkItemBooleanParameterWidget(PortableBooleanParameterDefinition ppd, IBindingProvider bindingProvider, boolean isReadOnly) {
        super((PortableParameterDefinition)ppd, bindingProvider);
        Set<String> bindings;
        this.parameterName.setText(ppd.getName());
        this.parameterValues.setEnabled(!isReadOnly);
        boolean isItemSelected = false;
        Boolean selectedItem = ppd.getValue();
        if (ppd.getValues() != null) {
            for (int index = 0; index < ppd.getValues().length; ++index) {
                Boolean item = ppd.getValues()[index];
                this.parameterValues.addItem(Boolean.toString(item));
                if (!item.equals(selectedItem)) continue;
                this.parameterValues.setSelectedIndex(index);
                isItemSelected = true;
            }
            if (!isItemSelected) {
                this.parameterValues.setSelectedIndex(0);
                ppd.setValue(Boolean.valueOf(this.parameterValues.getItemText(0)));
            }
        }
        if ((bindings = bindingProvider.getBindings(ppd.getClassName())).size() > 0) {
            this.lstAvailableBindings.clear();
            this.lstAvailableBindings.addItem(CommonConstants.INSTANCE.Choose());
            this.lstAvailableBindings.setEnabled(!isReadOnly);
            this.lstAvailableBindings.setVisible(true);
            int selectedIndex = 0;
            for (String binding : bindings) {
                this.lstAvailableBindings.addItem(binding);
                if (!binding.equals(ppd.getBinding())) continue;
                selectedIndex = this.lstAvailableBindings.getItemCount() - 1;
            }
            this.lstAvailableBindings.setSelectedIndex(selectedIndex);
            this.parameterValues.setEnabled(selectedIndex == 0 && !isReadOnly);
        }
    }

    @Override
    protected Widget getWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"parameterValues"})
    void parameterValuesOnChange(ChangeEvent event) {
        int index = this.parameterValues.getSelectedIndex();
        if (index == -1) {
            ((PortableBooleanParameterDefinition)this.ppd).setValue(null);
        } else {
            ((PortableBooleanParameterDefinition)this.ppd).setValue(Boolean.valueOf(this.parameterValues.getItemText(index)));
        }
    }

    @UiHandler(value={"lstAvailableBindings"})
    void lstAvailableBindingsOnChange(ChangeEvent event) {
        int index = this.lstAvailableBindings.getSelectedIndex();
        this.parameterValues.setEnabled(index == 0);
        if (index > 0) {
            ((PortableBooleanParameterDefinition)this.ppd).setValue(null);
            ((PortableBooleanParameterDefinition)this.ppd).setBinding(this.lstAvailableBindings.getItemText(index));
        } else {
            ((PortableBooleanParameterDefinition)this.ppd).setBinding("");
        }
    }

    static interface WorkItemBooleanParameterWidgetBinder
    extends UiBinder<HorizontalPanel, WorkItemBooleanParameterWidget> {
    }
}

