/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.Annotation;
import org.drools.workbench.models.datamodel.oracle.MethodInfo;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.model.LazyModelField;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleIncrementalPayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.FactNameToFQCNHandleRegistry;

public class AsyncPackageDataModelOracleUtilities {
    public static void populateDataModelOracle(AsyncPackageDataModelOracle oracle, PackageDataModelOracleIncrementalPayload payload) {
        if (payload == null) {
            return;
        }
        AsyncPackageDataModelOracleUtilities.populate(oracle, payload);
        oracle.filter();
    }

    private static void populate(AsyncPackageDataModelOracle oracle, PackageDataModelOracleIncrementalPayload payload) {
        oracle.addModelFields(payload.getModelFields());
        oracle.addFieldParametersType(payload.getFieldParametersType());
        oracle.addEventTypes(payload.getEventTypes());
        oracle.addTypeSources(payload.getTypeSources());
        oracle.addSuperTypes(payload.getSuperTypes());
        oracle.addTypeAnnotations(payload.getTypeAnnotations());
        oracle.addTypeFieldsAnnotations(payload.getTypeFieldsAnnotations());
        oracle.addMethodInformation(payload.getMethodInformation());
        oracle.addCollectionTypes(payload.getCollectionTypes());
    }

    public static Map<String, ModelField[]> filterModelFields(String packageName, Imports imports, Map<String, ModelField[]> projectModelFields, FactNameToFQCNHandleRegistry registry) {
        HashMap<String, ModelField[]> scopedModelFields = new HashMap<String, ModelField[]>();
        for (Map.Entry<String, ModelField[]> entry : projectModelFields.entrySet()) {
            String mfQualifiedType = entry.getKey();
            String mfPackageName = AsyncPackageDataModelOracleUtilities.getPackageName(mfQualifiedType);
            String mfTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(mfQualifiedType);
            if (registry.contains(mfTypeName)) {
                Set importStrings = imports.getImportStrings();
                if (mfPackageName.equals(packageName) || importStrings.contains(mfQualifiedType)) {
                    registry.add(mfTypeName, mfQualifiedType);
                }
            } else {
                registry.add(mfTypeName, mfQualifiedType);
            }
            if (!mfPackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(mfQualifiedType, imports)) continue;
            scopedModelFields.put(mfTypeName, AsyncPackageDataModelOracleUtilities.correctModelFields(packageName, entry.getValue(), imports));
        }
        return scopedModelFields;
    }

    public static Map<String, Boolean> filterCollectionTypes(String packageName, Imports imports, Map<String, Boolean> projectCollectionTypes) {
        HashMap<String, Boolean> scopedCollectionTypes = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> e : projectCollectionTypes.entrySet()) {
            String collectionQualifiedType = e.getKey();
            String collectionPackageName = AsyncPackageDataModelOracleUtilities.getPackageName(collectionQualifiedType);
            String collectionTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(collectionQualifiedType);
            if (!collectionPackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(collectionQualifiedType, imports)) continue;
            scopedCollectionTypes.put(collectionTypeName, e.getValue());
        }
        return scopedCollectionTypes;
    }

    public static Map<String, String> filterGlobalTypes(String packageName, Imports imports, Map<String, String> packageGlobalTypes) {
        HashMap<String, String> scopedGlobalTypes = new HashMap<String, String>();
        for (Map.Entry<String, String> e : packageGlobalTypes.entrySet()) {
            String globalQualifiedType = e.getValue();
            String globalPackageName = AsyncPackageDataModelOracleUtilities.getPackageName(globalQualifiedType);
            String globalTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(globalQualifiedType);
            if (!globalPackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(globalQualifiedType, imports)) continue;
            scopedGlobalTypes.put(e.getKey(), globalTypeName);
        }
        return scopedGlobalTypes;
    }

    public static Map<String, Boolean> filterEventTypes(String packageName, Imports imports, Map<String, Boolean> projectEventTypes) {
        HashMap<String, Boolean> scopedEventTypes = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> e : projectEventTypes.entrySet()) {
            String eventQualifiedType = e.getKey();
            String eventPackageName = AsyncPackageDataModelOracleUtilities.getPackageName(eventQualifiedType);
            String eventTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(eventQualifiedType);
            if (!eventPackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(eventQualifiedType, imports)) continue;
            scopedEventTypes.put(eventTypeName, e.getValue());
        }
        return scopedEventTypes;
    }

    public static Map<String, TypeSource> filterTypeSources(String packageName, Imports imports, Map<String, TypeSource> projectTypeSources) {
        HashMap<String, TypeSource> scopedTypeSources = new HashMap<String, TypeSource>();
        for (Map.Entry<String, TypeSource> e : projectTypeSources.entrySet()) {
            String typeQualifiedType = e.getKey();
            String typePackageName = AsyncPackageDataModelOracleUtilities.getPackageName(typeQualifiedType);
            String typeTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(typeQualifiedType);
            if (!typePackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(typeQualifiedType, imports)) continue;
            scopedTypeSources.put(typeTypeName, e.getValue());
        }
        return scopedTypeSources;
    }

    public static Map<String, List<String>> filterSuperTypes(String packageName, Imports imports, Map<String, List<String>> projectSuperTypes) {
        HashMap<String, List<String>> scopedSuperTypes = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : projectSuperTypes.entrySet()) {
            String typeQualifiedType = e.getKey();
            String typePackageName = AsyncPackageDataModelOracleUtilities.getPackageName(typeQualifiedType);
            String typeTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(typeQualifiedType);
            List<String> superTypeQualifiedTypes = e.getValue();
            if (superTypeQualifiedTypes == null) {
                if (!typePackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(typeQualifiedType, imports)) continue;
                scopedSuperTypes.put(typeTypeName, superTypeQualifiedTypes);
                continue;
            }
            if (!typePackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(typeQualifiedType, imports)) continue;
            ArrayList<String> result = new ArrayList<String>();
            for (String superTypeQualifiedType : superTypeQualifiedTypes) {
                String superTypePackageName = AsyncPackageDataModelOracleUtilities.getPackageName(superTypeQualifiedType);
                String superTypeTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(superTypeQualifiedType);
                if (superTypePackageName.equals(packageName) || AsyncPackageDataModelOracleUtilities.isImported(superTypeQualifiedType, imports)) {
                    result.add(superTypeTypeName);
                    continue;
                }
                result.add(superTypeQualifiedType);
            }
            scopedSuperTypes.put(typeTypeName, result);
        }
        return scopedSuperTypes;
    }

    public static Map<String, Set<Annotation>> filterTypeAnnotations(String packageName, Imports imports, Map<String, Set<Annotation>> projectTypeAnnotations) {
        HashMap<String, Set<Annotation>> scopedTypeAnnotations = new HashMap<String, Set<Annotation>>();
        for (Map.Entry<String, Set<Annotation>> e : projectTypeAnnotations.entrySet()) {
            String typeAnnotationQualifiedType = e.getKey();
            String typeAnnotationPackageName = AsyncPackageDataModelOracleUtilities.getPackageName(typeAnnotationQualifiedType);
            String typeAnnotationTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(typeAnnotationQualifiedType);
            if (!typeAnnotationPackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(typeAnnotationQualifiedType, imports)) continue;
            scopedTypeAnnotations.put(typeAnnotationTypeName, e.getValue());
        }
        return scopedTypeAnnotations;
    }

    public static Map<String, Map<String, Set<Annotation>>> filterTypeFieldsAnnotations(String packageName, Imports imports, Map<String, Map<String, Set<Annotation>>> projectTypeFieldsAnnotations) {
        HashMap<String, Map<String, Set<Annotation>>> scopedTypeFieldsAnnotations = new HashMap<String, Map<String, Set<Annotation>>>();
        for (Map.Entry<String, Map<String, Set<Annotation>>> e : projectTypeFieldsAnnotations.entrySet()) {
            String typeAnnotationQualifiedType = e.getKey();
            String typeAnnotationPackageName = AsyncPackageDataModelOracleUtilities.getPackageName(typeAnnotationQualifiedType);
            String typeAnnotationTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(typeAnnotationQualifiedType);
            if (!typeAnnotationPackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(typeAnnotationQualifiedType, imports)) continue;
            scopedTypeFieldsAnnotations.put(typeAnnotationTypeName, e.getValue());
        }
        return scopedTypeFieldsAnnotations;
    }

    public static Map<String, String[]> filterEnumDefinitions(String packageName, Imports imports, Map<String, String[]> enumDefinitions) {
        HashMap<String, String[]> scopedEnumLists = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> e : enumDefinitions.entrySet()) {
            String enumQualifiedType = AsyncPackageDataModelOracleUtilities.getQualifiedTypeFromEnumeration(e.getKey());
            String enumFieldName = AsyncPackageDataModelOracleUtilities.getFieldNameFromEnumeration(e.getKey());
            String enumPackageName = AsyncPackageDataModelOracleUtilities.getPackageName(enumQualifiedType);
            String enumTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(enumQualifiedType);
            if (!enumPackageName.equals(packageName) && !AsyncPackageDataModelOracleUtilities.isImported(enumQualifiedType, imports)) continue;
            scopedEnumLists.put(enumTypeName + "#" + enumFieldName, e.getValue());
        }
        return scopedEnumLists;
    }

    public static void visitMethodInformation(Map<String, List<MethodInfo>> projectMethodInformation, FactNameToFQCNHandleRegistry registry) {
        for (Map.Entry<String, List<MethodInfo>> e : projectMethodInformation.entrySet()) {
            String miQualifiedType = e.getKey();
            String miTypeName = AsyncPackageDataModelOracleUtilities.getTypeName(miQualifiedType);
            registry.add(miTypeName, miQualifiedType);
        }
    }

    public static Map<String, String> filterFieldParametersTypes(String packageName, Imports imports, Map<String, String> projectFieldParametersTypes) {
        HashMap<String, String> scopedFieldParametersType = new HashMap<String, String>();
        for (Map.Entry<String, String> e : projectFieldParametersTypes.entrySet()) {
            String fieldName = e.getKey();
            String fieldType = e.getValue();
            String fFieldName = AsyncPackageDataModelOracleUtilities.getFieldNameFromEnumeration(fieldName);
            String fFieldName_QualifiedType = AsyncPackageDataModelOracleUtilities.getQualifiedTypeFromEnumeration(fieldName);
            String fFieldName_PackageName = AsyncPackageDataModelOracleUtilities.getPackageName(fFieldName_QualifiedType);
            String fFieldName_TypeName = AsyncPackageDataModelOracleUtilities.getTypeName(fFieldName_QualifiedType);
            if (fFieldName_PackageName.equals(packageName) || AsyncPackageDataModelOracleUtilities.isImported(fFieldName_QualifiedType, imports)) {
                fieldName = fFieldName_TypeName;
            }
            String fFieldType_QualifiedType = AsyncPackageDataModelOracleUtilities.getQualifiedTypeFromEnumeration(fieldType);
            String fFieldType_PackageName = AsyncPackageDataModelOracleUtilities.getPackageName(fFieldType_QualifiedType);
            String fFieldType_TypeName = AsyncPackageDataModelOracleUtilities.getTypeName(fFieldType_QualifiedType);
            if (fFieldType_PackageName.equals(packageName) || AsyncPackageDataModelOracleUtilities.isImported(fFieldType_QualifiedType, imports)) {
                fieldType = fFieldType_TypeName;
            }
            scopedFieldParametersType.put(fieldName + "#" + fFieldName, fieldType);
        }
        return scopedFieldParametersType;
    }

    public static String getPackageName(String qualifiedType) {
        String packageName = qualifiedType;
        int dotIndex = packageName.lastIndexOf(".");
        if (dotIndex != -1) {
            return packageName.substring(0, dotIndex);
        }
        return "";
    }

    public static String getTypeName(String qualifiedType) {
        String typeName = qualifiedType;
        int dotIndex = typeName.lastIndexOf(".");
        if (dotIndex != -1) {
            typeName = typeName.substring(dotIndex + 1);
        }
        if (typeName.contains("$")) {
            typeName = typeName.replaceAll("\\$", ".");
        }
        return typeName;
    }

    private static String getQualifiedTypeFromEnumeration(String qualifiedType) {
        String typeName = qualifiedType;
        int hashIndex = typeName.lastIndexOf("#");
        if (hashIndex != -1) {
            typeName = typeName.substring(0, hashIndex);
        }
        return typeName;
    }

    private static String getFieldNameFromEnumeration(String qualifiedType) {
        String fieldName = qualifiedType;
        int hashIndex = fieldName.lastIndexOf("#");
        if (hashIndex != -1) {
            return fieldName.substring(hashIndex + 1);
        }
        return "";
    }

    public static ModelField[] correctModelFields(String packageName, ModelField[] originalModelFields, Imports imports) {
        if (originalModelFields == null) {
            return null;
        }
        ArrayList<ModelField> correctedModelFields = new ArrayList<ModelField>();
        for (ModelField mf : originalModelFields) {
            correctedModelFields.add(AsyncPackageDataModelOracleUtilities.correctModelFields(packageName, imports, mf));
        }
        ModelField[] result = new ModelField[correctedModelFields.size()];
        return correctedModelFields.toArray(result);
    }

    public static ModelField correctModelFields(String packageName, Imports imports, ModelField mf) {
        String mfClassName;
        String mfType = mf.getType();
        String mfClassName_QualifiedType = mfClassName = mf.getClassName();
        String mfClassName_PackageName = AsyncPackageDataModelOracleUtilities.getPackageName(mfClassName_QualifiedType);
        String mfClassName_TypeName = AsyncPackageDataModelOracleUtilities.getTypeName(mfClassName_QualifiedType);
        if (mfClassName_PackageName.equals(packageName) || AsyncPackageDataModelOracleUtilities.isImported(mfClassName_QualifiedType, imports)) {
            mfClassName = mfClassName_TypeName;
        }
        String mfType_QualifiedType = mfType;
        String mfType_PackageName = AsyncPackageDataModelOracleUtilities.getPackageName(mfType_QualifiedType);
        String mfType_TypeName = AsyncPackageDataModelOracleUtilities.getTypeName(mfType_QualifiedType);
        if (mfType_PackageName.equals(packageName) || AsyncPackageDataModelOracleUtilities.isImported(mfType_QualifiedType, imports)) {
            mfType = mfType_TypeName;
        }
        return AsyncPackageDataModelOracleUtilities.cloneModelField(mf, mfClassName, mfType);
    }

    private static ModelField cloneModelField(ModelField source, String mfClassName, String mfType) {
        if (source instanceof LazyModelField) {
            return new LazyModelField(source.getName(), mfClassName, source.getClassType(), source.getOrigin(), source.getAccessorsAndMutators(), mfType);
        }
        return new ModelField(source.getName(), mfClassName, source.getClassType(), source.getOrigin(), source.getAccessorsAndMutators(), mfType);
    }

    public static MethodInfo correctMethodInformation(String packageName, final MethodInfo originalMethodInformation, Imports imports) {
        List<MethodInfo> correctedMethodInformation = AsyncPackageDataModelOracleUtilities.correctMethodInformation(packageName, (List<MethodInfo>)new ArrayList<MethodInfo>(){
            {
                this.add(originalMethodInformation);
            }
        }, imports);
        if (correctedMethodInformation == null || correctedMethodInformation.isEmpty()) {
            return null;
        }
        return correctedMethodInformation.get(0);
    }

    public static List<MethodInfo> correctMethodInformation(String packageName, List<MethodInfo> originalMethodInformation, Imports imports) {
        ArrayList<MethodInfo> correctedMethodInformation = new ArrayList<MethodInfo>();
        for (MethodInfo mi : originalMethodInformation) {
            String miReturnType = mi.getReturnClassType();
            String miGenericReturnType = mi.getGenericType();
            String miParametricReturnType = mi.getParametricReturnType();
            String miReturnType_QualifiedType = miReturnType;
            String miReturnType_PackageName = AsyncPackageDataModelOracleUtilities.getPackageName(miReturnType_QualifiedType);
            String miReturnType_TypeName = AsyncPackageDataModelOracleUtilities.getTypeName(miReturnType_QualifiedType);
            if (miReturnType_PackageName.equals(packageName) || AsyncPackageDataModelOracleUtilities.isImported(miReturnType_QualifiedType, imports)) {
                miReturnType = miReturnType_TypeName;
            }
            String miGenericReturnType_QualifiedType = miGenericReturnType;
            String miGenericReturnType_PackageName = AsyncPackageDataModelOracleUtilities.getPackageName(miGenericReturnType_QualifiedType);
            String miGenericReturnType_TypeName = AsyncPackageDataModelOracleUtilities.getTypeName(miGenericReturnType_QualifiedType);
            if (miGenericReturnType_PackageName.equals(packageName) || AsyncPackageDataModelOracleUtilities.isImported(miGenericReturnType_QualifiedType, imports)) {
                miGenericReturnType = miGenericReturnType_TypeName;
            }
            if (miParametricReturnType != null) {
                String miParametricReturnType_QualifiedType = miParametricReturnType;
                String miParametricReturnType_PackageName = AsyncPackageDataModelOracleUtilities.getPackageName(miParametricReturnType_QualifiedType);
                String miParametricReturnType_TypeName = AsyncPackageDataModelOracleUtilities.getTypeName(miParametricReturnType_QualifiedType);
                if (miParametricReturnType_PackageName.equals(packageName) || AsyncPackageDataModelOracleUtilities.isImported(miParametricReturnType_QualifiedType, imports)) {
                    miParametricReturnType = miParametricReturnType_TypeName;
                }
            }
            correctedMethodInformation.add(new MethodInfo(mi.getName(), mi.getParams(), miReturnType, miParametricReturnType, miGenericReturnType));
        }
        return correctedMethodInformation;
    }

    private static boolean isImported(String qualifiedType, Imports imports) {
        Import item = new Import(qualifiedType.replaceAll("\\$", "."));
        return imports.contains(item);
    }
}

