/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.popups.workbench.configuration;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.workbench.configuration.ContextualView;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorComboBox;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorItemLabel;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserWorkbenchPreferences;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ForcedPlaceRequest;

@Dependent
public class WorkbenchConfigurationPopup
extends BaseModal {
    private static WorkbenchConfigurationPopupImplBinder uiBinder = (WorkbenchConfigurationPopupImplBinder)GWT.create(WorkbenchConfigurationPopupImplBinder.class);
    @UiField
    PropertyEditorComboBox languageListItems;
    @UiField
    PropertyEditorComboBox multipleModeItems;
    @UiField
    PropertyEditorItemLabel languageListItemsLabel;
    @UiField
    PropertyEditorItemLabel multipleModeItemsLabel;
    private PlaceManager placeManager;
    private PerspectiveManager perspectiveManager;
    private ContextualView contextualView;
    private Caller<UserPreferencesService> preferencesService;
    private CommonConstants constants = (CommonConstants)GWT.create(CommonConstants.class);
    private Map<String, String> languageMap = new HashMap<String, String>();
    private Map<String, String> viewModeMap = new HashMap<String, String>();

    @Inject
    public WorkbenchConfigurationPopup(PlaceManager placeManager, PerspectiveManager perspectiveManager, ContextualView contextualView, Caller<UserPreferencesService> preferencesService) {
        this.placeManager = placeManager;
        this.perspectiveManager = perspectiveManager;
        this.contextualView = contextualView;
        this.preferencesService = preferencesService;
        this.setTitle(this.constants.Workbench_Settings());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        com.google.gwt.user.client.Command okCommand = new com.google.gwt.user.client.Command(){

            public void execute() {
                WorkbenchConfigurationPopup.this.onOk();
                WorkbenchConfigurationPopup.this.hide();
            }
        };
        com.google.gwt.user.client.Command cancelCommand = new com.google.gwt.user.client.Command(){

            public void execute() {
                WorkbenchConfigurationPopup.this.hide();
            }
        };
        this.add((Widget)new ModalFooterOKCancelButtons(okCommand, cancelCommand));
        this.languageMap.put("default", this.constants.English());
        this.languageMap.put("zh_CN", this.constants.ChineseSimplified());
        this.languageMap.put("de", this.constants.German());
        this.languageMap.put("es", this.constants.Spanish());
        this.languageMap.put("fr", this.constants.French());
        this.languageMap.put("ja", this.constants.Japanese());
        this.languageMap.put("pt_BR", this.constants.Portuguese());
        this.languageMap.put("zh_TW", this.constants.ChineseTraditional());
        this.languageMap.put("ru", this.constants.Russian());
        this.viewModeMap.put("Advanced", this.constants.Advanced());
        this.viewModeMap.put("Basic", this.constants.Basic());
    }

    @AfterInitialization
    public void setup() {
        this.languageListItemsLabel.setText(this.constants.Language());
        this.multipleModeItemsLabel.setText(this.constants.View_Mode());
        this.setLanguageListItems();
        this.setMultipleModeItems(this.multipleModeItems);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<UserWorkbenchPreferences>(){

            public void callback(UserWorkbenchPreferences response) {
                if (response != null) {
                    WorkbenchConfigurationPopup.this.languageListItems.setSelectItemByText((String)WorkbenchConfigurationPopup.this.languageMap.get(response.getLanguage()));
                    WorkbenchConfigurationPopup.this.multipleModeItems.setSelectItemByText((String)WorkbenchConfigurationPopup.this.viewModeMap.get(response.getViewMode("all_prespectives")));
                    for (Map.Entry entry : response.getPerspectiveViewMode().entrySet()) {
                        WorkbenchConfigurationPopup.this.contextualView.setViewMode((String)entry.getKey(), (String)entry.getValue());
                    }
                    WorkbenchConfigurationPopup.this.refresh(response.getLanguage(), response.getViewMode("all_prespectives"), response);
                }
            }
        }, (ErrorCallback)new DefaultErrorCallback())).loadUserPreferences((UserPreference)new UserWorkbenchPreferences("default"));
    }

    public void onOk() {
        Pair selectedLanguage = this.languageListItems.getSelectedPair(this.languageListItems.getSelectedIndex());
        Pair selectedViewMode = this.multipleModeItems.getSelectedPair(this.multipleModeItems.getSelectedIndex());
        this.refresh((String)selectedLanguage.getK2(), (String)selectedViewMode.getK2(), null);
        this.saveUserWorkbenchPreferences((String)selectedLanguage.getK2(), (String)selectedViewMode.getK2());
    }

    private void saveUserWorkbenchPreferences(String language, String viewMode) {
        UserWorkbenchPreferences preferences = new UserWorkbenchPreferences(language);
        preferences.setViewMode("all_prespectives", viewMode);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
            }
        })).saveUserPreferences((UserPreference)preferences);
    }

    private void refresh(String selectedLanguageItem, String selectedMultipleMode, UserWorkbenchPreferences response) {
        boolean refreshPerspectiveFlag = true;
        boolean refreshWorkbenchFlag = true;
        if (selectedLanguageItem.equals(this.getCurrentLocaleName())) {
            refreshWorkbenchFlag = false;
        }
        if (selectedMultipleMode.equals(this.contextualView.getViewMode("all_prespectives"))) {
            refreshPerspectiveFlag = false;
        }
        this.switchMode(refreshPerspectiveFlag, refreshWorkbenchFlag);
        this.refreshWorkbench(selectedLanguageItem, refreshWorkbenchFlag, response);
    }

    private void setLanguageListItems() {
        String[] languages;
        this.languageListItems.clear();
        for (String language : languages = this.getAvailableLocaleNames()) {
            this.languageListItems.addItem(Pair.newPair((Object)this.languageMap.get(language), (Object)language));
        }
    }

    private void setCurrentLanguage(String languageName, UserWorkbenchPreferences response) {
        String isRefresh = Window.Location.getParameter((String)"isRefresh");
        if (response != null && (isRefresh == null || isRefresh.equals(""))) {
            Window.Location.assign((String)Window.Location.createUrlBuilder().removeParameter(this.getLocaleQueryParam()).setParameter(this.getCurrentLocaleQueryParam(), new String[]{languageName}).setParameter("isRefresh", new String[]{"false"}).buildString());
        } else if (response == null) {
            Window.Location.assign((String)Window.Location.createUrlBuilder().removeParameter(this.getLocaleQueryParam()).setParameter(this.getCurrentLocaleQueryParam(), new String[]{languageName}).buildString());
        }
    }

    private void refreshWorkbench(String selectedLanguageItem, boolean refreshWorkbenchFlag, UserWorkbenchPreferences response) {
        if (!refreshWorkbenchFlag) {
            return;
        }
        if (selectedLanguageItem == null || selectedLanguageItem.equals("")) {
            this.showFieldEmptyWarning();
        } else {
            this.setCurrentLanguage(selectedLanguageItem, response);
        }
    }

    private void setMultipleModeItems(PropertyEditorComboBox multipleModeItems) {
        multipleModeItems.clear();
        multipleModeItems.addItem(Pair.newPair((Object)this.viewModeMap.get("Basic"), (Object)"Basic"));
        multipleModeItems.addItem(Pair.newPair((Object)this.viewModeMap.get("Advanced"), (Object)"Advanced"));
    }

    private void switchMode(boolean refreshPerspectiveFlag, boolean refreshWorkbenchFlag) {
        String isRefresh = Window.Location.getParameter((String)"isRefresh");
        if (refreshPerspectiveFlag && (!refreshWorkbenchFlag || refreshWorkbenchFlag && isRefresh.equals("false"))) {
            String modeName = this.contextualView.getViewMode("all_prespectives");
            if (modeName.equals("Basic")) {
                this.contextualView.setViewMode("all_prespectives", "Advanced");
            } else {
                this.contextualView.setViewMode("all_prespectives", "Basic");
            }
            this.refreshPerspective();
        }
    }

    private void refreshPerspective() {
        final PerspectiveActivity currentPerspective = this.perspectiveManager.getCurrentPerspective();
        this.perspectiveManager.removePerspectiveStates(new Command(){

            public void execute() {
                if (currentPerspective != null) {
                    ForcedPlaceRequest pr = new ForcedPlaceRequest(currentPerspective.getIdentifier(), currentPerspective.getPlace().getParameters());
                    WorkbenchConfigurationPopup.this.placeManager.goTo((PlaceRequest)pr);
                }
            }
        });
    }

    private void showFieldEmptyWarning() {
        ErrorPopup.showMessage((String)this.constants.PleaseSetAName());
    }

    protected String[] getAvailableLocaleNames() {
        return LocaleInfo.getAvailableLocaleNames();
    }

    protected String getLocaleQueryParam() {
        return LocaleInfo.getLocaleQueryParam();
    }

    protected String getCurrentLocaleName() {
        return LocaleInfo.getCurrentLocale().getLocaleName();
    }

    protected String getCurrentLocaleQueryParam() {
        LocaleInfo.getCurrentLocale();
        return LocaleInfo.getLocaleQueryParam();
    }

    static interface WorkbenchConfigurationPopupImplBinder
    extends UiBinder<Widget, WorkbenchConfigurationPopup> {
    }
}

