/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.gwtbootstrap3.client.ui.ListBox;
import org.jboss.errai.bus.client.api.BusErrorCallback;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.enums.EnumDropdownService;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.widget.EnumDropDownUtilities;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

public class CachingEnumDropDownUtilities
extends EnumDropDownUtilities {
    static final Map<String, String[]> enumCache = new HashMap<String, String[]>();
    static final Map<String, Set<ListBox>> pendingListBoxesCache = new HashMap<String, Set<ListBox>>();

    @Override
    public void setDropDownData(String value, DropDownData dropData, boolean isMultipleSelect, Path resource, ListBox listBox) {
        if (dropData == null) {
            this.fillDropDown(value, new String[0], isMultipleSelect, listBox);
            return;
        }
        if (dropData.getFixedList() != null) {
            this.getEnumsFromFixedList(value, dropData, isMultipleSelect, listBox);
            return;
        }
        if (dropData.getQueryExpression() != null) {
            this.getEnumsFromServer(value, dropData, isMultipleSelect, resource, listBox);
        }
    }

    @Override
    public void fillDropDown(String value, DropDownData dropData, boolean isMultipleSelect, ListBox listBox) {
        super.fillDropDown(value, dropData, isMultipleSelect, listBox);
    }

    @Override
    public void fillDropDown(String value, String[] enumeratedValues, boolean isMultipleSelect, ListBox listBox) {
        super.fillDropDown(value, enumeratedValues, isMultipleSelect, listBox);
    }

    private void getEnumsFromFixedList(String value, DropDownData dropData, boolean isMultipleSelect, ListBox listBox) {
        String key = this.buildKey(dropData);
        if (!enumCache.containsKey(key)) {
            enumCache.put(key, dropData.getFixedList());
        }
        this.fillDropDown(value, enumCache.get(key), isMultipleSelect, listBox);
    }

    private void getEnumsFromServer(String value, DropDownData dropData, boolean isMultipleSelect, Path resource, ListBox listBox) {
        String key = this.buildKey(dropData);
        if (enumCache.containsKey(key)) {
            String[] items = enumCache.get(key);
            if (items.length == 0) {
                if (!pendingListBoxesCache.containsKey(key)) {
                    pendingListBoxesCache.put(key, new HashSet());
                }
                Set<ListBox> pendingListBoxes = pendingListBoxesCache.get(key);
                pendingListBoxes.add(listBox);
                return;
            }
            this.fillDropDown(value, items, isMultipleSelect, listBox);
            return;
        }
        enumCache.put(key, new String[0]);
        this.loadEnumsFromServer(key, value, dropData, isMultipleSelect, resource, listBox);
    }

    void loadEnumsFromServer(final String key, final String value, final DropDownData dropData, final boolean isMultipleSelect, final Path resource, final ListBox listBox) {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                BusyPopup.showMessage((String)CommonConstants.INSTANCE.RefreshingList());
                ((EnumDropdownService)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<String[]>(){

                    public void callback(String[] response) {
                        CachingEnumDropDownUtilities.this.enumsLoadedFromServer(key, value, isMultipleSelect, listBox, response);
                    }
                }, (BusErrorCallback)new BusErrorCallback(){

                    public boolean error(Message message, Throwable throwable) {
                        BusyPopup.close();
                        return false;
                    }
                }, EnumDropdownService.class)).loadDropDownExpression(resource, dropData.getValuePairs(), dropData.getQueryExpression());
            }
        });
    }

    void enumsLoadedFromServer(String key, String value, boolean isMultipleSelect, ListBox listBox, String[] response) {
        BusyPopup.close();
        if (response.length == 0) {
            response = new String[]{CommonConstants.INSTANCE.UnableToLoadList()};
        } else {
            Set<ListBox> pendingListBoxes = pendingListBoxesCache.remove(key);
            if (pendingListBoxes != null && !pendingListBoxes.isEmpty()) {
                for (ListBox lb : pendingListBoxes) {
                    this.fillDropDown(value, response, isMultipleSelect, lb);
                }
            }
        }
        enumCache.put(key, response);
        this.fillDropDown(value, response, isMultipleSelect, listBox);
    }

    private String buildKey(DropDownData enumDefinition) {
        if (enumDefinition.getFixedList() != null) {
            return this.buildFixedListKey(enumDefinition.getFixedList());
        }
        return this.buildQueryExpressionKey(enumDefinition.getQueryExpression(), enumDefinition.getValuePairs());
    }

    private String buildFixedListKey(String[] items) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            sb.append(item).append("#");
        }
        String key = sb.toString();
        return key;
    }

    private String buildQueryExpressionKey(String queryExpression, String[] items) {
        StringBuilder sb = new StringBuilder();
        sb.append(queryExpression).append("#");
        sb.append(this.buildFixedListKey(items));
        String key = sb.toString();
        return key;
    }
}

