/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Package;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

@Dependent
public class PackageListBox
extends Composite {
    private SimplePanel panel = new SimplePanel();
    private Select select;
    protected Caller<KieProjectService> projectService;
    private Map<String, Package> packages;

    @Inject
    public PackageListBox(Caller<KieProjectService> projectService) {
        this.projectService = projectService;
        this.initWidget((Widget)this.panel);
        this.getElement().getStyle().setMarginBottom(15.0, Style.Unit.PX);
        this.packages = new HashMap<String, Package>();
    }

    public void setContext(ProjectContext context, boolean includeDefaultPackage) {
        this.setContext(context, includeDefaultPackage, null);
    }

    public void setContext(ProjectContext context, final boolean includeDefaultPackage, final Command packagesLoadedCommand) {
        this.noPackage();
        this.packages.clear();
        if (context.getActiveProject() == null) {
            return;
        }
        final Package activePackage = context.getActivePackage();
        ((KieProjectService)this.projectService.call((RemoteCallback)new RemoteCallback<Set<Package>>(){

            public void callback(Set<Package> pkgs) {
                ArrayList<Package> sortedPackages = new ArrayList<Package>();
                sortedPackages.addAll(pkgs);
                Collections.sort(sortedPackages, (p1, p2) -> p1.getCaption().compareTo(p2.getCaption()));
                if (!includeDefaultPackage) {
                    sortedPackages.remove(0);
                }
                if (sortedPackages.size() == 0) {
                    return;
                }
                PackageListBox.this.addPackagesToSelect(sortedPackages, activePackage);
                if (packagesLoadedCommand != null) {
                    packagesLoadedCommand.execute();
                }
            }
        })).resolvePackages(context.getActiveProject());
    }

    private void addPackagesToSelect(List<Package> sortedPackages, Package activePackage) {
        this.clearSelect();
        for (Package pkg : sortedPackages) {
            this.addPackage(pkg, activePackage);
        }
        this.refreshSelect();
    }

    public Package getSelectedPackage() {
        if (this.packages.size() == 0 || this.select == null) {
            return null;
        }
        return this.packages.get(this.select.getValue());
    }

    void addPackage(Package pkg, Package activePackage) {
        Option option = new Option();
        option.setText(pkg.getCaption());
        this.select.add((Widget)option);
        this.packages.put(pkg.getCaption(), pkg);
        if (pkg.equals((Object)activePackage)) {
            this.select.setValue((Object)pkg.getCaption());
        }
    }

    void noPackage() {
        this.clearSelect();
        Option option = new Option();
        option.setText(CommonConstants.INSTANCE.ItemUndefinedPath());
        this.select.add((Widget)option);
        this.select.setEnabled(false);
        this.refreshSelect();
    }

    void clearSelect() {
        if (this.select != null) {
            this.select.removeFromParent();
            this.removeSelect((Element)this.select.getElement());
        }
        this.select = new Select();
        this.panel.setWidget((Widget)this.select);
    }

    void refreshSelect() {
        this.select.refresh();
    }

    private native void removeSelect(Element var1);
}

