/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ForcedPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@ApplicationScoped
public class ResetPerspectivesMenuBuilder
implements MenuFactory.CustomMenuBuilder {
    @Inject
    private PerspectiveManager perspectiveManager;
    @Inject
    private PlaceManager placeManager;
    private AnchorListItem link = new AnchorListItem();

    public ResetPerspectivesMenuBuilder() {
        this.link.setIcon(IconType.MEDKIT);
        this.link.setTitle(CommonConstants.INSTANCE.ResetPerspectivesTooltip());
        this.link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)CommonConstants.INSTANCE.PromptResetPerspectives())) {
                    final PerspectiveActivity currentPerspective = ResetPerspectivesMenuBuilder.this.perspectiveManager.getCurrentPerspective();
                    ResetPerspectivesMenuBuilder.this.perspectiveManager.removePerspectiveStates(new Command(){

                        public void execute() {
                            if (currentPerspective != null) {
                                ForcedPlaceRequest pr = new ForcedPlaceRequest(currentPerspective.getIdentifier(), currentPerspective.getPlace().getParameters());
                                ResetPerspectivesMenuBuilder.this.placeManager.goTo((PlaceRequest)pr);
                            }
                        }
                    });
                }
            }
        });
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return ResetPerspectivesMenuBuilder.this.link;
            }

            public MenuPosition getPosition() {
                return MenuPosition.RIGHT;
            }
        };
    }
}

