/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.popups.validation;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.Range;
import java.util.List;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.client.console.widget.MessageTableWidget;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKButton;

public class ValidationPopup
extends BaseModal {
    private static ValidationPopup instance = new ValidationPopup();
    protected final MessageTableWidget<ValidationMessage> dataGrid = new MessageTableWidget<ValidationMessage>(MessageTableWidget.Mode.PAGED){
        {
            this.setDataProvider((AbstractDataProvider)new ListDataProvider());
        }
    };

    private ValidationPopup() {
        this.setTitle(CommonConstants.INSTANCE.ValidationErrors());
        this.setHideOtherModals(false);
        this.setBody((Widget)this.dataGrid);
        this.add((Widget)new ModalFooterOKButton(new Command(){

            public void execute() {
                ValidationPopup.this.hide();
            }
        }));
        this.dataGrid.setToolBarVisible(false);
        this.dataGrid.addLevelColumn(10, (MessageTableWidget.ColumnExtractor)new MessageTableWidget.ColumnExtractor<Level>(){

            public Level getValue(Object row) {
                Level level = ((ValidationMessage)row).getLevel();
                return level != null ? level : Level.ERROR;
            }
        });
        this.dataGrid.addTextColumn(90, (MessageTableWidget.ColumnExtractor)new MessageTableWidget.ColumnExtractor<String>(){

            public String getValue(Object row) {
                return ((ValidationMessage)row).getText();
            }
        });
    }

    private void setMessages(List<ValidationMessage> messages) {
        ListDataProvider listDataProvider = (ListDataProvider)this.dataGrid.getDataProvider();
        listDataProvider.getList().clear();
        listDataProvider.getList().addAll(messages);
        this.dataGrid.setVisibleRangeAndClearData(new Range(0, 5), true);
    }

    public static void showMessages(List<ValidationMessage> messages) {
        instance.setMessages(messages);
        instance.show();
    }
}

