/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.workitems;

import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.kie.workbench.common.widgets.client.workitems.IBindingProvider;
import org.kie.workbench.common.widgets.client.workitems.WorkItemParameterWidget;
import org.kie.workbench.common.widgets.client.workitems.WorkItemParameterWidgetFactory;

public class WorkItemParametersWidget
extends VerticalPanel {
    private List<PortableParameterDefinition> parameters;
    private final IBindingProvider bindingProvider;
    private final boolean isReadOnly;

    public WorkItemParametersWidget(IBindingProvider bindingProvider, boolean isReadOnly) {
        this.bindingProvider = bindingProvider;
        this.isReadOnly = isReadOnly;
    }

    public void setParameters(Collection<PortableParameterDefinition> parameters) {
        this.clear();
        this.parameters = this.sort(parameters);
        for (PortableParameterDefinition ppd : this.parameters) {
            WorkItemParameterWidget pw = WorkItemParameterWidgetFactory.getWidget(ppd, this.bindingProvider, this.isReadOnly);
            this.add((Widget)pw);
        }
    }

    private List<PortableParameterDefinition> sort(Collection<PortableParameterDefinition> parameters) {
        ArrayList<PortableParameterDefinition> sortedParameters = new ArrayList<PortableParameterDefinition>();
        sortedParameters.addAll(parameters);
        Collections.sort(sortedParameters, new Comparator<PortableParameterDefinition>(){

            @Override
            public int compare(PortableParameterDefinition o1, PortableParameterDefinition o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedParameters;
    }
}

