/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.popups.validation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.Range;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.client.console.widget.MessageTableWidget;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopupView;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

@Dependent
@Templated
public class ValidationPopupViewImpl
implements ValidationPopupView {
    @DataField(value="view")
    Div view;
    @DataField(value="validationTable")
    MessageTableWidget<ValidationMessage> validationTable;
    @DataField(value="yesButton")
    Button yesButton;
    @DataField(value="cancelButton")
    Button cancelButton;
    private ValidationPopupView.Presenter presenter;
    private BaseModal modal;
    private ListDataProvider<ValidationMessage> validationTableDataProvider;
    private TranslationService translationService;

    @Inject
    public ValidationPopupViewImpl(Div view, Button yesButton, Button cancelButton, TranslationService translationService) {
        this.view = view;
        this.yesButton = yesButton;
        this.cancelButton = cancelButton;
        this.translationService = translationService;
        this.validationTable = new MessageTableWidget(MessageTableWidget.Mode.PAGED);
        this.validationTable.setDataProvider((AbstractDataProvider)new ListDataProvider());
        this.validationTable.addLevelColumn(10, row -> {
            Level level = ((ValidationMessage)row).getLevel();
            return level != null ? level : Level.ERROR;
        });
        this.validationTable.addTextColumn(90, row -> ((ValidationMessage)row).getText());
        this.validationTableDataProvider = new ListDataProvider();
        this.validationTableDataProvider.addDataDisplay(this.validationTable);
    }

    public void init(ValidationPopupView.Presenter presenter) {
        this.presenter = presenter;
    }

    public HTMLElement getElement() {
        return this.view;
    }

    @Override
    public void setYesButtonText(String text) {
        this.yesButton.setTextContent(text);
    }

    @Override
    public void setCancelButtonText(String text) {
        this.cancelButton.setTextContent(text);
    }

    @Override
    public void showYesButton(boolean show) {
        this.yesButton.getStyle().setProperty("display", show ? "inline" : "none");
    }

    @Override
    public void showCancelButton(boolean show) {
        this.cancelButton.getStyle().setProperty("display", show ? "inline" : "none");
    }

    @Override
    public void setValidationMessages(List<ValidationMessage> messages) {
        ListDataProvider listDataProvider = (ListDataProvider)this.validationTable.getDataProvider();
        listDataProvider.getList().clear();
        listDataProvider.getList().addAll(messages);
        this.validationTable.setVisibleRangeAndClearData(new Range(0, 5), true);
    }

    @Override
    public void show() {
        this.modal = new BaseModal();
        this.modal.setTitle(this.translationService.getTranslation("ValidationPopupViewImpl.ValidationErrors"));
        this.modal.setBody((Widget)ElementWrapperWidget.getWidget((HTMLElement)this.view));
        this.modal.show();
    }

    @Override
    public void hide() {
        if (this.modal != null) {
            this.modal.hide();
        }
    }

    @EventHandler(value={"yesButton"})
    public void yesButtonClicked(ClickEvent clickEvent) {
        this.presenter.onYesButtonClicked();
    }

    @EventHandler(value={"cancelButton"})
    public void cancelButtonClicked(ClickEvent clickEvent) {
        this.presenter.onCancelButtonClicked();
    }
}

