/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.handlers.PackageListBox;
import org.kie.workbench.common.widgets.client.handlers.PackageListBoxView;
import org.kie.workbench.common.widgets.client.widget.KieSelectElement;

@Templated
public class PackageListBoxViewImpl
implements PackageListBoxView {
    private KieSelectElement kieSelectElement;
    @Inject
    @DataField(value="packageSelectContainer")
    HTMLDivElement packageSelectContainer;
    private PackageListBox presenter;

    @Inject
    public PackageListBoxViewImpl(KieSelectElement kieSelectElement) {
        this.kieSelectElement = kieSelectElement;
    }

    @Override
    public void setPresenter(PackageListBox presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setUp(String activePackage, Map<String, String> packageNames) {
        this.kieSelectElement.setup((Element)this.packageSelectContainer, this.buildOptions(packageNames), activePackage, s -> this.onSelectionChange());
    }

    private List<KieSelectElement.Option> buildOptions(Map<String, String> packageNames) {
        ArrayList<KieSelectElement.Option> options = new ArrayList<KieSelectElement.Option>();
        for (Map.Entry<String, String> entry : packageNames.entrySet()) {
            options.add(this.newOption(entry.getKey(), entry.getValue()));
        }
        return options;
    }

    KieSelectElement.Option newOption(String name, String value) {
        if (value.isEmpty()) {
            value = name;
        }
        return new KieSelectElement.Option(name, value);
    }

    private void onSelectionChange() {
        this.presenter.onPackageSelected(this.kieSelectElement.getValue());
        this.kieSelectElement.setValue(this.kieSelectElement.getValue());
    }
}

