/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;

public class HumanReadableDataTypes {
    private static Map<String, String> TYPE_DESCRIPTIONS = new HashMap<String, String>(){
        {
            this.put("Integer", CommonConstants.INSTANCE.WholeNumberInteger());
            this.put("Boolean", CommonConstants.INSTANCE.TrueOrFalse());
            this.put("String", CommonConstants.INSTANCE.Text());
            this.put("java.util.Date", CommonConstants.INSTANCE.Date());
            this.put("java.math.BigDecimal", CommonConstants.INSTANCE.DecimalNumber());
        }
    };

    public static Map<String, String> getTypeDescriptions() {
        return TYPE_DESCRIPTIONS;
    }

    public static String getUserFriendlyTypeName(String systemTypeName) {
        String userFriendlyName;
        if (systemTypeName.contains(".")) {
            systemTypeName = systemTypeName.substring(systemTypeName.lastIndexOf(".") + 1);
        }
        if ((userFriendlyName = TYPE_DESCRIPTIONS.get(systemTypeName)) == null) {
            return systemTypeName;
        }
        return userFriendlyName;
    }
}

