/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLLabelElement;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.widget.KSessionSelector;
import org.kie.workbench.common.widgets.client.widget.KSessionSelectorView;
import org.kie.workbench.common.widgets.client.widget.KieSelectElement;

@Templated
public class KSessionSelectorViewImpl
implements KSessionSelectorView {
    HTMLDocument document;
    @DataField(value="kbaseSelectContainer")
    HTMLDivElement kbaseSelectContainer;
    KieSelectElement kbaseSelect;
    @Inject
    @DataField(value="ksessionSelectContainer")
    HTMLDivElement ksessionSelectContainer;
    KieSelectElement ksessionSelect;
    @Inject
    @DataField(value="warningLabel")
    HTMLLabelElement warningLabel;
    private KSessionSelector presenter;

    public KSessionSelectorViewImpl() {
    }

    @Inject
    public KSessionSelectorViewImpl(HTMLDocument document, HTMLDivElement kbaseSelectContainer, HTMLDivElement ksessionSelectContainer, KieSelectElement kbaseSelect, KieSelectElement ksessionSelect, HTMLLabelElement warningLabel) {
        this.document = document;
        this.kbaseSelectContainer = kbaseSelectContainer;
        this.ksessionSelectContainer = ksessionSelectContainer;
        this.kbaseSelect = kbaseSelect;
        this.ksessionSelect = ksessionSelect;
        this.warningLabel = warningLabel;
    }

    @Override
    public void setPresenter(KSessionSelector presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setSelected(String kbase, String ksession) {
        this.kbaseSelect.setValue(kbase);
        this.ksessionSelect.setValue(ksession);
        this.onSelectionChange();
    }

    @Override
    public void addKBases(String ... names) {
        this.kbaseSelect.setup((Element)this.kbaseSelectContainer, this.buildOptions(names), names[0], new Consumer<String>(){

            @Override
            public void accept(String s) {
                KSessionSelectorViewImpl.this.presenter.onKBaseSelected(s);
            }
        });
    }

    List<KieSelectElement.Option> buildOptions(String[] values) {
        return Arrays.stream(values).map(this::newOption).collect(Collectors.toList());
    }

    KieSelectElement.Option newOption(String e) {
        return new KieSelectElement.Option(e, e);
    }

    @Override
    public void setKSessions(List<String> ksessions) {
        String[] names = ksessions.toArray(new String[ksessions.size()]);
        this.ksessionSelect.setup((Element)this.ksessionSelectContainer, this.buildOptions(names), names[0], s -> this.onSelectionChange());
    }

    @Override
    public void showWarningSelectedKSessionDoesNotExist() {
        this.warningLabel.style.setProperty("visibility", "visible");
    }

    @Override
    public String getSelectedKSessionName() {
        return this.ksessionSelect.getValue();
    }

    void onSelectionChange() {
        this.presenter.onSelectionChange();
    }
}

