/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.widgets.client.handlers.PackageListBoxView;
import org.uberfire.mvp.Command;

@Dependent
public class PackageListBox
implements IsElement {
    private PackageListBoxView view;
    private WorkspaceProjectContext projectContext;
    protected Caller<KieModuleService> moduleService;
    private Map<String, Package> packages;
    private String selectedPackage = null;

    @Inject
    public PackageListBox(PackageListBoxView view, WorkspaceProjectContext projectContext, Caller<KieModuleService> moduleService) {
        this.view = view;
        this.projectContext = projectContext;
        this.moduleService = moduleService;
        this.packages = new HashMap<String, Package>();
        view.setPresenter(this);
    }

    public void setUp(boolean includeDefaultPackage) {
        this.setUp(includeDefaultPackage, null);
    }

    public void setUp(boolean includeDefaultPackage, Command packagesLoadedCommand) {
        this.packages.clear();
        this.showListOfPackages(includeDefaultPackage, packagesLoadedCommand);
    }

    private void showListOfPackages(boolean includeDefaultPackage, Command packagesLoadedCommand) {
        Module activeModule = this.projectContext.getActiveModule().orElse(null);
        if (activeModule == null) {
            return;
        }
        ((KieModuleService)this.moduleService.call(pkgs -> ((KieModuleService)this.moduleService.call(activePackage -> {
            List<Package> sortedPackages = this.getSortedPackages(includeDefaultPackage, (Set<Package>)pkgs);
            if (sortedPackages.isEmpty()) {
                return;
            }
            this.addPackagesToSelect(sortedPackages, (Package)activePackage);
            if (packagesLoadedCommand != null) {
                packagesLoadedCommand.execute();
            }
        })).resolveDefaultWorkspacePackage(activeModule))).resolvePackages(activeModule);
    }

    private List<Package> getSortedPackages(boolean includeDefaultPackage, Set<Package> pkgs) {
        ArrayList<Package> sortedPackages = new ArrayList<Package>(pkgs);
        Collections.sort(sortedPackages, (p1, p2) -> p1.getCaption().compareTo(p2.getCaption()));
        if (!includeDefaultPackage && !sortedPackages.isEmpty() && "".equals(((Package)sortedPackages.get(0)).getPackageName())) {
            sortedPackages.remove(0);
        }
        return sortedPackages;
    }

    private void addPackagesToSelect(List<Package> sortedPackages, Package activePackage) {
        HashMap<String, String> packageNames = new HashMap<String, String>();
        for (Package pkg : sortedPackages) {
            packageNames.put(pkg.getCaption(), pkg.getPackageName());
            this.packages.put(pkg.getCaption(), pkg);
        }
        this.selectedPackage = this.getSelectedPackage(activePackage, packageNames);
        this.view.setUp(this.selectedPackage, packageNames);
    }

    private String getSelectedPackage(Package activePackage, Map<String, String> packageNames) {
        if (packageNames.containsKey(activePackage.getCaption())) {
            return activePackage.getCaption();
        }
        if (!packageNames.isEmpty()) {
            return packageNames.keySet().iterator().next();
        }
        return null;
    }

    public Package getSelectedPackage() {
        if (this.packages.isEmpty()) {
            return null;
        }
        return this.packages.get(this.selectedPackage);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void onPackageSelected(String selectedPackage) {
        this.selectedPackage = selectedPackage;
    }
}

