/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.datamodel;

import java.util.ArrayList;
import java.util.Map;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.widgets.client.datamodel.DataModelHelper;
import org.kie.workbench.common.widgets.client.datamodel.FilteredEnumLists;

class EnumDropDownDataFactory {
    private FilteredEnumLists filteredEnumLists;
    private CurrentValues currentValues;

    EnumDropDownDataFactory(FilteredEnumLists filteredEnumLists, Map<String, String> currentValueMap) {
        this.filteredEnumLists = filteredEnumLists;
        this.currentValues = new CurrentValues(currentValueMap);
    }

    public DropDownData getEnums(String type, String field) {
        DropDownData dropDownData;
        if (!this.currentValues.isEmpty() && (dropDownData = this.getDependentEnumDropDown(type, field)) != null) {
            return dropDownData;
        }
        return DropDownData.create((String[])this.filteredEnumLists.getEnumValues(type, field));
    }

    private DropDownData getDependentEnumDropDown(String type, String field) {
        String[] fieldsNeeded;
        String[] valuePairs;
        Object _typeFields = this.filteredEnumLists.getTypeFields(type, field);
        if (_typeFields instanceof String) {
            DropDownData data = DropDownData.create((String[])((String[])this.filteredEnumLists.get(this.buildKey(type, field, (String)_typeFields))));
            if (data != null) {
                return data;
            }
        } else if (_typeFields != null && this.isNotEmpty(valuePairs = this.collectValuePairs(fieldsNeeded = (String[])_typeFields))) {
            return DropDownData.create((String)DataModelHelper.getQueryString(type, field, fieldsNeeded, this.filteredEnumLists), (String[])valuePairs);
        }
        return null;
    }

    private boolean isNotEmpty(String[] valuePairs) {
        return valuePairs.length > 0 && valuePairs[0] != null;
    }

    private String[] collectValuePairs(String[] fieldsNeeded) {
        String[] valuePairs = new String[fieldsNeeded.length];
        for (int i = 0; i < fieldsNeeded.length; ++i) {
            for (CurrentValueEntry currentValueEntry : this.currentValues) {
                if (!currentValueEntry.getFieldName().equals(fieldsNeeded[i])) continue;
                valuePairs[i] = fieldsNeeded[i] + "=" + currentValueEntry.getFieldValue();
            }
        }
        return valuePairs;
    }

    private String buildKey(String type, String field, String _typeFields) {
        String typeFields = _typeFields;
        StringBuilder dataEnumListsKeyBuilder = new StringBuilder(type).append("#").append(field);
        boolean addOpeninColumn = true;
        String[] splitTypeFields = typeFields.split(",");
        for (int j = 0; j < splitTypeFields.length; ++j) {
            String typeField = splitTypeFields[j];
            for (CurrentValueEntry currentValueEntry : this.currentValues) {
                if (!currentValueEntry.getFieldName().trim().equals(typeField.trim())) continue;
                if (addOpeninColumn) {
                    dataEnumListsKeyBuilder.append("[");
                    addOpeninColumn = false;
                }
                dataEnumListsKeyBuilder.append(typeField).append("=").append(currentValueEntry.getFieldValue());
                if (j == splitTypeFields.length - 1) continue;
                dataEnumListsKeyBuilder.append(",");
            }
        }
        if (!addOpeninColumn) {
            dataEnumListsKeyBuilder.append("]");
        }
        return dataEnumListsKeyBuilder.toString();
    }

    private class CurrentValueEntry {
        private final String fieldName;
        private final String fieldValue;

        public CurrentValueEntry(String fieldName, String fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }
    }

    private class CurrentValues
    extends ArrayList<CurrentValueEntry> {
        private CurrentValues() {
        }

        public CurrentValues(Map<String, String> currentValueMap) {
            for (Map.Entry<String, String> entry : currentValueMap.entrySet()) {
                this.add(new CurrentValueEntry(entry.getKey(), entry.getValue()));
            }
        }
    }
}

