/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.datamodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FilteredEnumLists
extends HashMap<String, String[]> {
    private transient Map<String, Object> enumLookupFields;

    public String[] getEnumValues(String factType, String field) {
        return (String[])this.get(factType + "#" + field);
    }

    Object getTypeFields(String type, String field) {
        return this.loadDataEnumLookupFields().get(type + "#" + field);
    }

    boolean isDependentEnum(String factType, String parentField, String childField) {
        Map<String, Object> enums = this.loadDataEnumLookupFields();
        if (enums.isEmpty()) {
            return false;
        }
        String key = factType + "#" + childField;
        if (!enums.containsKey(key)) {
            return false;
        }
        Object _parent = enums.get(key);
        if (_parent instanceof String) {
            String _parentField = (String)_parent;
            if (_parentField.equals(parentField)) {
                return true;
            }
            return this.isDependentEnum(factType, parentField, _parentField);
        }
        return false;
    }

    Map<String, Object> loadDataEnumLookupFields() {
        if (this.enumLookupFields == null) {
            this.enumLookupFields = new HashMap<String, Object>();
            Set keys = this.keySet();
            for (String key : keys) {
                if (key.indexOf(91) == -1) continue;
                int ix = key.indexOf(91);
                String factField = key.substring(0, ix);
                String predicate = key.substring(ix + 1, key.indexOf(93));
                if (predicate.indexOf(61) > -1) {
                    String[] bits = predicate.split(",");
                    StringBuilder typeFieldBuilder = new StringBuilder();
                    for (int i = 0; i < bits.length; ++i) {
                        typeFieldBuilder.append(bits[i].substring(0, bits[i].indexOf(61)));
                        if (i == bits.length - 1) continue;
                        typeFieldBuilder.append(",");
                    }
                    this.enumLookupFields.put(factField, typeFieldBuilder.toString());
                    continue;
                }
                String[] fields = predicate.split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = fields[i].trim();
                }
                this.enumLookupFields.put(factField, fields);
            }
        }
        return this.enumLookupFields;
    }

    boolean hasEnums(String qualifiedFactField) {
        boolean hasEnums = false;
        String key = qualifiedFactField.replace(".", "#");
        String dependentType = key + "[";
        for (String e : this.keySet()) {
            if (e.equals(key)) {
                return true;
            }
            if (!e.startsWith(dependentType)) continue;
            return true;
        }
        return hasEnums;
    }
}

