/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceView;
import org.kie.workbench.common.widgets.client.handlers.PackageListBox;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

@Templated
@ApplicationScoped
public class NewResourceViewImpl
implements NewResourceView,
IsElement {
    @DataField
    DivElement fileNameGroup = Document.get().createDivElement();
    @DataField
    FormLabel fileTypeLabel = new FormLabel();
    @Inject
    @DataField
    TextBox fileNameTextBox;
    @Inject
    @DataField
    HelpBlock fileNameHelpInline;
    @Inject
    @DataField
    PackageListBox packageListBox;
    @DataField
    DivElement packageGroup = Document.get().createDivElement();
    @Inject
    @DataField
    HelpBlock packageHelpInline;
    @DataField
    DivElement handlerExtensionsGroup = Document.get().createDivElement();
    @Inject
    @DataField
    FlowPanel handlerExtensions;
    TranslationService translationService;
    BaseModal modal;
    private final Command cancelCommand = new Command(){

        public void execute() {
            NewResourceViewImpl.this.hide();
        }
    };
    private NewResourcePresenter presenter;
    private final Command okCommand = new Command(){

        public void execute() {
            NewResourceViewImpl.this.onOKButtonClick();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    @Inject
    public NewResourceViewImpl(TranslationService translationService) {
        this.translationService = translationService;
        this.footer.enableOkButton(true);
    }

    @PostConstruct
    public void init() {
        this.modal = new BaseModal();
        this.modal.setBody((Widget)ElementWrapperWidget.getWidget((HTMLElement)this.getElement()));
        this.modal.add((Widget)this.footer);
        this.fileNameTextBox.setPlaceholder(this.translationService.getTranslation("NewResourceViewImpl.resourceNamePlaceholder"));
        this.fileTypeLabel.setShowRequiredIndicator(true);
    }

    public void init(NewResourcePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void show() {
        this.fileNameTextBox.setText("");
        this.clearErrors();
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void setActiveHandler(NewResourceHandler handler) {
        List<Pair<String, ? extends IsWidget>> extensions = handler.getExtensions();
        boolean showExtensions = extensions != null && !extensions.isEmpty();
        this.fileTypeLabel.setText(handler.getDescription());
        this.packageListBox.setUp(handler.supportsDefaultPackage());
        this.handlerExtensions.clear();
        this.handlerExtensionsGroup.getStyle().setDisplay(showExtensions ? Style.Display.BLOCK : Style.Display.NONE);
        if (showExtensions) {
            extensions.forEach(pair -> {
                if (pair.getK1() != null && !((String)pair.getK1()).isEmpty()) {
                    FormLabel extensionLabel = (FormLabel)GWT.create(FormLabel.class);
                    extensionLabel.setText((String)pair.getK1());
                    this.handlerExtensions.add((Widget)extensionLabel);
                }
                this.handlerExtensions.add((IsWidget)pair.getK2());
            });
        }
    }

    void onOKButtonClick() {
        this.clearErrors();
        final String fileName = this.fileNameTextBox.getText();
        if (fileName == null || fileName.trim().isEmpty()) {
            this.fileNameGroup.addClassName(ValidationState.ERROR.getCssName());
            this.fileNameHelpInline.setText(this.translationService.getTranslation("NewResourceViewImpl.fileNameIsMandatory"));
            return;
        }
        if (this.packageListBox.getSelectedPackage() == null) {
            this.packageGroup.addClassName(ValidationState.ERROR.getCssName());
            this.packageHelpInline.setText(this.translationService.getTranslation("NewResourceViewImpl.MissingPath"));
            return;
        }
        this.presenter.validate(fileName, new ValidatorWithReasonCallback(){

            public void onSuccess() {
                NewResourceViewImpl.this.presenter.makeItem(fileName);
            }

            public void onFailure() {
            }

            public void onFailure(String reason) {
                NewResourceViewImpl.this.fileNameGroup.addClassName(ValidationState.ERROR.getCssName());
                NewResourceViewImpl.this.fileNameHelpInline.setText(reason);
            }
        });
    }

    @Override
    public Package getSelectedPackage() {
        return this.packageListBox.getSelectedPackage();
    }

    @Override
    public void setTitle(String title) {
        this.modal.setTitle(title);
    }

    @Override
    public void setResourceName(String resourceName) {
        this.fileNameTextBox.setText(resourceName);
    }

    protected void clearErrors() {
        this.fileNameGroup.removeClassName(ValidationState.ERROR.getCssName());
        this.fileNameHelpInline.clearError();
        this.packageGroup.removeClassName(ValidationState.ERROR.getCssName());
        this.packageHelpInline.clearError();
    }
}

