/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers.workbench.configuration;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.http.client.UrlBuilder;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.widgets.client.handlers.workbench.configuration.ConfigurationComboBoxItemWidget;
import org.kie.workbench.common.widgets.client.handlers.workbench.configuration.WorkbenchConfigurationHandler;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.services.shared.preferences.UserWorkbenchPreferences;

@ApplicationScoped
public class LanguageConfigurationHandler
extends WorkbenchConfigurationHandler {
    private static final String LANGUAGE_SECLECTOR_HADNLER_ID = "languageSeclector";
    private Map<String, String> languageMap = new HashMap<String, String>();
    private CommonConstants constants = (CommonConstants)GWT.create(CommonConstants.class);
    @Inject
    ConfigurationComboBoxItemWidget languageItem;

    public LanguageConfigurationHandler() {
        this.languageMap.put("default", this.constants.English());
        this.languageMap.put("zh_CN", this.constants.ChineseSimplified());
        this.languageMap.put("de", this.constants.German());
        this.languageMap.put("es", this.constants.Spanish());
        this.languageMap.put("fr", this.constants.French());
        this.languageMap.put("ja", this.constants.Japanese());
        this.languageMap.put("pt_BR", this.constants.Portuguese());
    }

    @Override
    public String getDescription() {
        return this.constants.Language_Selector();
    }

    @Override
    public void configurationSetting(boolean isInit) {
        String languageName = (String)this.languageItem.getSelectedItem().getK2();
        String isRefresh = Window.Location.getParameter((String)"isRefresh");
        if ((isRefresh == null || isRefresh.equals("")) && isInit) {
            UrlBuilder urlBuilder = Window.Location.createUrlBuilder().removeParameter(LocaleInfo.getLocaleQueryParam());
            LocaleInfo.getCurrentLocale();
            Window.Location.assign((String)urlBuilder.setParameter(LocaleInfo.getLocaleQueryParam(), new String[]{languageName}).setParameter("isRefresh", new String[]{"false"}).buildString());
        } else if (!isInit) {
            UrlBuilder urlBuilder = Window.Location.createUrlBuilder().removeParameter(LocaleInfo.getLocaleQueryParam());
            LocaleInfo.getCurrentLocale();
            Window.Location.assign((String)urlBuilder.setParameter(LocaleInfo.getLocaleQueryParam(), new String[]{languageName}).buildString());
        }
    }

    @Override
    protected void setDefaultConfigurationValues(UserWorkbenchPreferences response) {
        this.languageItem.setSelectedItem(response.getLanguage());
    }

    @Override
    protected void initHandler() {
        String[] languages;
        this.languageItem.extensionItemLabel.setText(this.constants.Language());
        this.languageItem.getExtensionItem().clear();
        for (String language : languages = LocaleInfo.getAvailableLocaleNames()) {
            this.languageItem.getExtensionItem().addItem(Pair.newPair((Object)this.languageMap.get(language), (Object)language));
        }
        super.getExtensions().add((Pair<String, ? extends Composite>)Pair.newPair((Object)LANGUAGE_SECLECTOR_HADNLER_ID, (Object)((Object)this.languageItem)));
    }

    @Override
    protected UserWorkbenchPreferences getSelectedUserWorkbenchPreferences() {
        UserWorkbenchPreferences preference = super.getPreference();
        if (preference != null) {
            String selectedlanguage = (String)this.languageItem.getSelectedItem().getK1();
            preference.setLanguage(selectedlanguage);
            return preference;
        }
        preference = new UserWorkbenchPreferences((String)this.languageItem.getSelectedItem().getK1());
        return preference;
    }
}

