/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.cards.frame;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.cards.frame.CardFrameComponent;

@Templated
public class CardFrameComponentView
implements CardFrameComponent.View {
    public static final String CARD_UUID_ATTR = "data-card-uuid";
    @DataField(value="view")
    private final HTMLDivElement view;
    @DataField(value="icon")
    private final HTMLElement icon;
    @DataField(value="title-text")
    private final HTMLHeadingElement titleText;
    @DataField(value="title-input")
    private final HTMLInputElement titleInput;
    @DataField(value="input-close-button")
    private final HTMLButtonElement inputCloseButton;
    @DataField(value="edit-mode")
    private final HTMLDivElement editMode;
    @DataField(value="ok-button")
    private final HTMLButtonElement okButton;
    @DataField(value="close-button")
    private final HTMLButtonElement closeButton;
    @DataField(value="content")
    private final HTMLDivElement content;
    private CardFrameComponent presenter;

    @Inject
    public CardFrameComponentView(HTMLDivElement view, @Named(value="span") HTMLElement icon, @Named(value="h2") HTMLHeadingElement titleText, HTMLInputElement titleInput, HTMLButtonElement inputCloseButton, HTMLDivElement editMode, HTMLButtonElement okButton, HTMLButtonElement closeButton, HTMLDivElement content) {
        this.view = view;
        this.icon = icon;
        this.titleText = titleText;
        this.titleInput = titleInput;
        this.inputCloseButton = inputCloseButton;
        this.editMode = editMode;
        this.okButton = okButton;
        this.closeButton = closeButton;
        this.content = content;
    }

    public void init(CardFrameComponent presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"title-text"})
    public void onTitleTextClick(ClickEvent e) {
        this.presenter.enableEditMode();
    }

    @EventHandler(value={"ok-button"})
    public void onOkButtonClick(ClickEvent e) {
        this.presenter.changeTitle();
    }

    @EventHandler(value={"close-button"})
    public void onCloseButtonClick(ClickEvent e) {
        this.presenter.refreshView();
    }

    @EventHandler(value={"input-close-button"})
    public void onInputCloseButtonClick(ClickEvent e) {
        this.titleInput.value = "";
    }

    @EventHandler(value={"title-input"})
    public void onTitleInputKeyDownEvent(KeyDownEvent event) {
        if (this.isEscape(event)) {
            event.preventDefault();
            this.presenter.refreshView();
        }
        if (this.isEnter(event)) {
            event.preventDefault();
            this.presenter.changeTitle();
        }
    }

    @Override
    public void setUUID(String uuid) {
        this.view.setAttribute(CARD_UUID_ATTR, uuid);
    }

    @Override
    public void setIcon(String cssClassName) {
        this.icon.classList.add(new String[]{cssClassName});
    }

    @Override
    public void setTitle(String title) {
        this.titleText.textContent = title;
        this.titleInput.value = title;
    }

    @Override
    public String getTitle() {
        return this.titleInput.value;
    }

    @Override
    public void setContent(HTMLElement content) {
        this.content.appendChild((Node)content);
    }

    @Override
    public void enableReadOnlyMode() {
        this.titleText.hidden = false;
        this.editMode.hidden = true;
    }

    @Override
    public void enableEditMode() {
        this.titleText.hidden = true;
        this.editMode.hidden = false;
        this.titleInput.focus();
    }

    @Override
    public void setupToggleTitle(boolean enabled) {
        String readOnlyCSSClass = "read-only";
        this.titleText.classList.toggle("read-only", !enabled);
    }

    private boolean isEscape(KeyDownEvent event) {
        return event.getNativeKeyCode() == 27;
    }

    private boolean isEnter(KeyDownEvent event) {
        return event.getNativeKeyCode() == 13;
    }
}

