/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.search.common;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class JavaStreamHelper<T> {
    private final List<T> list;

    private JavaStreamHelper(List<T> list) {
        this.list = list;
    }

    public static <T> JavaStreamHelper<T> indexedStream(List<T> list) {
        return new JavaStreamHelper<T>(list);
    }

    public Stream<Tuple<T>> filter(BiFunction<Integer, T, Boolean> filter) {
        AtomicInteger index = new AtomicInteger(-1);
        return this.list.stream().filter((? super T element) -> {
            int currentIndex = index.incrementAndGet();
            return (Boolean)filter.apply(currentIndex, element);
        }).map(e -> new Tuple<Object>(index.get(), e));
    }

    public static class Tuple<T> {
        private final Integer index;
        private final T element;

        Tuple(Integer index, T element) {
            this.index = index;
            this.element = element;
        }

        public Integer getIndex() {
            return this.index;
        }

        public T getElement() {
            return this.element;
        }
    }
}

