/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.popups.validation;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationMessageTranslatorUtils;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopupView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class ValidationPopup
implements ValidationPopupView.Presenter {
    private ValidationPopupView view;
    private ValidationMessageTranslatorUtils validationMessageTranslatorUtils;
    private TranslationService translationService;
    private Command yesCommand;
    private Command cancelCommand;

    @Inject
    public ValidationPopup(ValidationPopupView view, ValidationMessageTranslatorUtils validationMessageTranslatorUtils, TranslationService translationService) {
        this.view = view;
        this.validationMessageTranslatorUtils = validationMessageTranslatorUtils;
        this.translationService = translationService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void showMessages(List<ValidationMessage> messages) {
        this.clear();
        this.view.setCancelButtonText(this.translationService.getTranslation("ValidationPopup.Cancel"));
        this.view.showCancelButton(true);
        this.initAndShowModal(() -> {}, () -> {}, messages);
    }

    public void showTranslatedMessages(List<ValidationMessage> messages) {
        this.showMessages(this.validationMessageTranslatorUtils.translate(messages));
    }

    public void showCopyValidationMessages(Command yesCommand, Command cancelCommand, List<ValidationMessage> validationMessages) {
        this.clear();
        this.view.setYesButtonText(this.translationService.getTranslation("ValidationPopup.YesCopyAnyway"));
        this.view.showYesButton(true);
        this.view.setCancelButtonText(this.translationService.getTranslation("ValidationPopup.Cancel"));
        this.view.showCancelButton(true);
        this.initAndShowModal(yesCommand, cancelCommand, validationMessages);
    }

    public void showSaveValidationMessages(Command yesCommand, Command cancelCommand, List<ValidationMessage> validationMessages) {
        this.clear();
        this.view.setYesButtonText(this.translationService.getTranslation("ValidationPopup.YesSaveAnyway"));
        this.view.showYesButton(true);
        this.view.setCancelButtonText(this.translationService.getTranslation("ValidationPopup.Cancel"));
        this.view.showCancelButton(true);
        this.initAndShowModal(yesCommand, cancelCommand, validationMessages);
    }

    public void showDeleteValidationMessages(Command yesCommand, Command cancelCommand, List<ValidationMessage> validationMessages) {
        this.clear();
        this.view.setYesButtonText(this.translationService.getTranslation("ValidationPopup.YesDeleteAnyway"));
        this.view.showYesButton(true);
        this.view.setCancelButtonText(this.translationService.getTranslation("ValidationPopup.Cancel"));
        this.view.showCancelButton(true);
        this.initAndShowModal(yesCommand, cancelCommand, validationMessages);
    }

    private void initAndShowModal(Command yesCommand, Command cancelCommand, List<ValidationMessage> validationMessages) {
        this.yesCommand = (Command)PortablePreconditions.checkNotNull((String)"yesCommand", (Object)yesCommand);
        this.cancelCommand = (Command)PortablePreconditions.checkNotNull((String)"cancelCommand", (Object)cancelCommand);
        this.view.setValidationMessages(this.validationMessageTranslatorUtils.translate(validationMessages));
        this.view.show();
    }

    private void clear() {
        this.view.showYesButton(false);
        this.view.showCancelButton(false);
    }

    @Override
    public void onYesButtonClicked() {
        if (this.yesCommand != null) {
            this.yesCommand.execute();
        }
        this.view.hide();
    }

    @Override
    public void onCancelButtonClicked() {
        if (this.cancelCommand != null) {
            this.cancelCommand.execute();
        }
        this.view.hide();
    }
}

