/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import java.util.List;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.widget.KSessionSelector;
import org.kie.workbench.common.widgets.client.widget.KSessionSelectorView;

@Templated
public class KSessionSelectorViewImpl
implements KSessionSelectorView {
    Document document;
    @DataField(value="kbaseSelect")
    Select kbaseSelect;
    @Inject
    @DataField(value="ksessionSelect")
    Select ksessionSelect;
    @Inject
    @DataField(value="warningLabel")
    Label warningLabel;
    private KSessionSelector presenter;

    public KSessionSelectorViewImpl() {
    }

    @Inject
    public KSessionSelectorViewImpl(Document document, Select kbaseSelect, Select ksessionSelect, Label warningLabel) {
        this.document = document;
        this.kbaseSelect = kbaseSelect;
        this.ksessionSelect = ksessionSelect;
        this.warningLabel = warningLabel;
    }

    @Override
    public void setPresenter(KSessionSelector presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setSelected(String kbase, String ksession) {
        this.kbaseSelect.setValue(kbase);
        this.ksessionSelect.setValue(ksession);
        this.onSelectionChange();
    }

    @Override
    public void addKBase(String name) {
        this.kbaseSelect.add((HTMLElement)this.createOption(name));
    }

    @Override
    public void setKSessions(List<String> ksessions) {
        this.removeChildren(this.ksessionSelect);
        for (String ksession : ksessions) {
            this.ksessionSelect.add((HTMLElement)this.createOption(ksession));
        }
    }

    private Option createOption(String value) {
        Option option = (Option)this.document.createElement("option");
        option.setText(value);
        return option;
    }

    private void removeChildren(Select select) {
        while (select.hasChildNodes()) {
            select.removeChild(select.getLastChild());
        }
    }

    @Override
    public void showWarningSelectedKSessionDoesNotExist() {
        this.warningLabel.setHidden(false);
    }

    @Override
    public void clear() {
        this.removeChildren(this.kbaseSelect);
        this.removeChildren(this.ksessionSelect);
    }

    @Override
    public String getSelectedKSessionName() {
        return this.ksessionSelect.getValue();
    }

    @EventHandler(value={"kbaseSelect"})
    public void onKBaseChange(ChangeEvent event) {
        this.presenter.onKBaseSelected(this.kbaseSelect.getValue());
    }

    @EventHandler(value={"ksessionSelect"})
    public void onKSessionSelected(ChangeEvent event) {
        this.onSelectionChange();
    }

    void onSelectionChange() {
        this.presenter.onSelectionChange();
    }
}

