/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.popups.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationMessageTranslator;

@ApplicationScoped
public class ValidationMessageTranslatorUtils {
    private List<ValidationMessageTranslator> validationMessageTranslators = new ArrayList<ValidationMessageTranslator>();

    public ValidationMessageTranslatorUtils() {
    }

    @Inject
    public ValidationMessageTranslatorUtils(Instance<ValidationMessageTranslator> checkTranslators) {
        checkTranslators.forEach(this.validationMessageTranslators::add);
    }

    public List<ValidationMessage> translate(List<ValidationMessage> messages) {
        return messages.stream().map(m -> this.lookUpTranslation((ValidationMessage)m)).collect(Collectors.toList());
    }

    private ValidationMessage lookUpTranslation(ValidationMessage messageToTranslate) {
        return this.validationMessageTranslators.stream().filter(t -> t.accept(messageToTranslate)).map(t -> t.translate(messageToTranslate)).findFirst().orElse(messageToTranslate);
    }

    void setValidationMessageTranslators(List<ValidationMessageTranslator> messageTranslators) {
        this.validationMessageTranslators = messageTranslators;
    }
}

