/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.search.component;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;

@Templated
@Dependent
public class SearchBarComponentView
implements SearchBarComponent.View {
    static final String HIDDEN = "hidden";
    @DataField(value="search-container")
    private final HTMLButtonElement searchContainer;
    @DataField(value="search-button")
    private final HTMLButtonElement searchButton;
    @DataField(value="prev-element")
    private final HTMLButtonElement prevElement;
    @DataField(value="next-element")
    private final HTMLButtonElement nextElement;
    @DataField(value="close-search")
    private final HTMLButtonElement closeSearch;
    @DataField(value="search-input")
    private final HTMLInputElement inputElement;
    @DataField(value="current-result")
    private final HTMLElement currentResult;
    @DataField(value="total-of-results")
    private final HTMLElement totalOfResults;
    private final TranslationService translationService;
    private SearchBarComponent<?> presenter;

    @Inject
    public SearchBarComponentView(HTMLButtonElement searchButton, HTMLButtonElement searchContainer, HTMLButtonElement prevElement, HTMLButtonElement nextElement, HTMLButtonElement closeSearch, HTMLInputElement inputElement, TranslationService translationService, @Named(value="span") HTMLElement currentResult, @Named(value="span") HTMLElement totalOfResults) {
        this.searchButton = searchButton;
        this.searchContainer = searchContainer;
        this.prevElement = prevElement;
        this.nextElement = nextElement;
        this.closeSearch = closeSearch;
        this.inputElement = inputElement;
        this.translationService = translationService;
        this.currentResult = currentResult;
        this.totalOfResults = totalOfResults;
    }

    public void init(SearchBarComponent searchBarComponent) {
        this.presenter = searchBarComponent;
        this.inputElement.placeholder = this.translationService.format("SearchBarComponentView.Find", new Object[0]);
        this.disableSearch();
    }

    @EventHandler(value={"search-button"})
    public void onSearchButtonClick(ClickEvent clickEvent) {
        this.toggle();
        clickEvent.preventDefault();
        clickEvent.stopPropagation();
    }

    @EventHandler(value={"next-element"})
    public void onNextElementClick(ClickEvent clickEvent) {
        this.presenter.nextResult();
        clickEvent.preventDefault();
        clickEvent.stopPropagation();
    }

    @EventHandler(value={"prev-element"})
    public void onPrevElementClick(ClickEvent clickEvent) {
        this.presenter.previousResult();
        clickEvent.preventDefault();
        clickEvent.stopPropagation();
    }

    @EventHandler(value={"close-search"})
    public void onCloseSearchClick(ClickEvent clickEvent) {
        this.disableSearch();
        clickEvent.preventDefault();
        clickEvent.stopPropagation();
    }

    @EventHandler(value={"search-input"})
    public void onSearchInputKeyPress(KeyUpEvent keyEvent) {
        int keyCode = keyEvent.getNativeKeyCode();
        switch (keyCode) {
            case 13: {
                this.search(this.inputElement.value);
                break;
            }
            case 27: {
                this.disableSearch();
            }
        }
    }

    @Override
    public void setCurrentResultNumber(Integer currentResultNumber) {
        this.currentResult.textContent = currentResultNumber.toString();
    }

    @Override
    public void setTotalOfResultsNumber(Integer totalOfResultsNumber) {
        this.totalOfResults.textContent = totalOfResultsNumber.toString();
    }

    @Override
    public void disableSearch() {
        this.searchContainer.classList.add(new String[]{HIDDEN});
        this.inputElement.value = "";
        this.presenter.closeIndex();
    }

    private void search(String value) {
        this.presenter.search(value);
    }

    private void toggle() {
        if (this.isContainerHidden()) {
            this.enableSearch();
        } else {
            this.disableSearch();
        }
    }

    private void enableSearch() {
        this.searchContainer.classList.remove(new String[]{HIDDEN});
        this.inputElement.focus();
    }

    private boolean isContainerHidden() {
        return this.searchContainer.classList.contains(HIDDEN);
    }
}

