/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.search.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.common.HasSearchableElements;
import org.kie.workbench.common.widgets.client.search.common.Searchable;
import org.uberfire.mvp.Command;

public abstract class BaseEditorSearchIndex<T extends Searchable>
implements EditorSearchIndex<T> {
    private final List<HasSearchableElements<T>> hasSearchableElementsList = new ArrayList<HasSearchableElements<T>>();
    private List<T> results = new ArrayList<T>();
    private T currentResult;
    private String currentTerm;
    private Integer currentAssetHash = null;
    private Command searchPerformedCallback = () -> {};
    private Command noResultsFoundCallback = () -> {};
    private Command clearCurrentResultsCallback = () -> {};
    private Command searchClosedCallback = () -> {};
    private Supplier<Integer> currentAssetHashcodeSupplier;

    @Override
    public void setSearchPerformedCallback(Command searchPerformedCallback) {
        this.searchPerformedCallback = searchPerformedCallback;
    }

    @Override
    public List<HasSearchableElements<T>> getSubIndexes() {
        return this.hasSearchableElementsList;
    }

    @Override
    public void registerSubIndex(HasSearchableElements<T> hasSearchableElements) {
        this.hasSearchableElementsList.add(hasSearchableElements);
    }

    @Override
    public void search(String term) {
        Optional<Object> result;
        boolean isNewSearch;
        this.triggerClearCurrentResultsCallback();
        boolean bl = isNewSearch = !Objects.equals(term, this.currentTerm) || this.isDirty();
        if (isNewSearch) {
            this.loadSearchResults(term);
            result = this.getFirstSearchResult();
        } else {
            result = this.findNextElement();
        }
        this.currentResult = result.orElse(null);
        this.currentTerm = term;
        this.triggerOnFoundCommand();
        this.triggerOnSearchPerformedCommand();
    }

    @Override
    public int getCurrentResultNumber() {
        return this.results.size() > 0 ? this.getCurrentResultIndex() + 1 : 0;
    }

    @Override
    public int getTotalOfResultsNumber() {
        return this.results.size();
    }

    @Override
    public void close() {
        this.results = new ArrayList<T>();
        this.currentTerm = "";
        this.currentResult = null;
        this.triggerOnSearchPerformedCommand();
        this.triggerSearchClosedCommand();
    }

    @Override
    public void setNoResultsFoundCallback(Command callback) {
        this.noResultsFoundCallback = callback;
    }

    @Override
    public void setClearCurrentResultsCallback(Command callback) {
        this.clearCurrentResultsCallback = callback;
    }

    @Override
    public void setSearchClosedCallback(Command searchClosedCallback) {
        this.searchClosedCallback = searchClosedCallback;
    }

    @Override
    public boolean isDirty() {
        return this.currentAssetHash != null && !Objects.equals(this.currentAssetHash, this.getCurrentAssetHashcode());
    }

    @Override
    public void nextResult() {
        Optional<Object> result = this.findNextElement();
        this.currentResult = result.orElse(null);
        this.triggerOnFoundCommand();
        this.triggerOnSearchPerformedCommand();
    }

    @Override
    public void previousResult() {
        Optional<Object> result = this.findPreviousElement();
        this.currentResult = result.orElse(null);
        this.triggerOnFoundCommand();
        this.triggerOnSearchPerformedCommand();
    }

    @Override
    public Integer getCurrentAssetHashcode() {
        return this.getCurrentAssetHashcodeSupplier().map(Supplier::get).orElseThrow(() -> new UnsupportedOperationException("The asset hashcode supplier must be set in the 'EditorSearchIndex'."));
    }

    public void setCurrentAssetHashcodeSupplier(Supplier<Integer> currentAssetHashcodeSupplier) {
        this.currentAssetHashcodeSupplier = currentAssetHashcodeSupplier;
    }

    private Optional<Supplier<Integer>> getCurrentAssetHashcodeSupplier() {
        return Optional.ofNullable(this.currentAssetHashcodeSupplier);
    }

    List<T> getResults() {
        return this.results;
    }

    String getCurrentTerm() {
        return this.currentTerm;
    }

    private Optional<T> getFirstSearchResult() {
        if (this.results.size() > 0) {
            return Optional.of(this.results.get(0));
        }
        return Optional.empty();
    }

    private Optional<T> getLastSearchResult() {
        int totalOfResults = this.results.size();
        if (totalOfResults > 0) {
            return Optional.of(this.results.get(totalOfResults - 1));
        }
        return Optional.empty();
    }

    private Optional<T> findNextElement() {
        int nextElementIndex = this.getCurrentResultIndex() + 1;
        if (nextElementIndex < this.results.size()) {
            return Optional.of(this.results.get(nextElementIndex));
        }
        return this.getFirstSearchResult();
    }

    private Optional<T> findPreviousElement() {
        int previousElementIndex = this.getCurrentResultIndex() - 1;
        if (previousElementIndex >= 0) {
            return Optional.of(this.results.get(previousElementIndex));
        }
        return this.getLastSearchResult();
    }

    private Integer getCurrentResultIndex() {
        return this.getCurrentResult().map(c -> this.results.indexOf(c)).orElse(0);
    }

    private void loadSearchResults(String term) {
        List<T> searchableElements = this.getSearchableElements();
        this.updateCurrentHashcode();
        this.updateResultsState(term, searchableElements);
    }

    private void updateResultsState(String term, List<T> searchableElements) {
        this.results = searchableElements.stream().filter(element -> element.matches(term)).collect(Collectors.toList());
    }

    private void updateCurrentHashcode() {
        this.currentAssetHash = this.getCurrentAssetHashcode();
    }

    private void triggerOnFoundCommand() {
        this.triggerClearCurrentResultsCallback();
        if (this.getCurrentResult().isPresent()) {
            ((Searchable)this.getCurrentResult().get()).onFound().execute();
        } else {
            this.triggerNoResultsFoundCommand();
        }
    }

    private void triggerNoResultsFoundCommand() {
        this.noResultsFoundCallback.execute();
    }

    void triggerOnSearchPerformedCommand() {
        if (!Objects.isNull(this.searchPerformedCallback)) {
            this.searchPerformedCallback.execute();
        }
    }

    @Override
    public Optional<T> getCurrentResult() {
        return Optional.ofNullable(this.currentResult);
    }

    private void triggerClearCurrentResultsCallback() {
        this.clearCurrentResultsCallback.execute();
    }

    private void triggerSearchClosedCommand() {
        this.searchClosedCallback.execute();
    }

    protected abstract List<T> getSearchableElements();
}

