/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourceView;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

@ApplicationScoped
public class NewResourcePresenter {
    private NewResourceView view;
    private final TranslationService translationService;
    private NewResourceHandler activeHandler = null;

    @Inject
    public NewResourcePresenter(NewResourceView view, TranslationService translationService) {
        this.view = view;
        this.translationService = translationService;
    }

    @PostConstruct
    private void setup() {
        this.view.init(this);
    }

    public void show(NewResourceHandler handler) {
        this.activeHandler = (NewResourceHandler)PortablePreconditions.checkNotNull((String)"handler", (Object)handler);
        this.view.show();
        this.view.setActiveHandler(this.activeHandler);
        this.view.setTitle(this.translationService.getTranslation("NewResourceViewImpl.popupTitle") + " " + this.getActiveHandlerDescription());
    }

    public void validate(String fileName, ValidatorWithReasonCallback callback) {
        if (this.activeHandler != null) {
            this.activeHandler.validate(fileName, callback);
        }
    }

    public void makeItem(String fileName) {
        if (this.activeHandler != null) {
            this.activeHandler.create(this.view.getSelectedPackage(), fileName, this);
        }
    }

    public void complete() {
        this.view.hide();
    }

    private String getActiveHandlerDescription() {
        if (this.activeHandler != null) {
            return this.activeHandler.getDescription();
        }
        return "";
    }

    public void setResourceName(String resourceName) {
        this.view.setResourceName(resourceName);
    }
}

