/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.guvnor.common.services.shared.file.upload.FileOperation;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.ext.widgets.common.client.common.FileUploadFormEncoder;
import org.uberfire.mvp.Command;

public class AttachmentFileWidget
extends Composite {
    private FileUpload up;
    private final Form form = (Form)GWT.create(Form.class);
    private final HorizontalPanel fields = (HorizontalPanel)GWT.create(HorizontalPanel.class);
    private final TextBox fieldFilePath = this.getHiddenField("attachmentPath", "");
    private final TextBox fieldFileName = this.getHiddenField("fileName", "");
    private final TextBox fieldFileFullPath = this.getHiddenField("attachmentFullPath", "");
    private final TextBox fieldFileOperation = this.getHiddenField("operation", "");
    private com.google.gwt.user.client.Command successCallback;
    private com.google.gwt.user.client.Command errorCallback;
    private String[] validFileExtensions;
    private ClickHandler uploadButtonClickHanlder;
    private FileUploadFormEncoder formEncoder = new FileUploadFormEncoder();

    public AttachmentFileWidget() {
        this.setup(false);
    }

    public AttachmentFileWidget(String[] validFileExtensions) {
        this.setup(false);
        this.setAccept(validFileExtensions);
    }

    public AttachmentFileWidget(boolean addFileUpload) {
        this.setup(addFileUpload);
    }

    public AttachmentFileWidget(String[] validFileExtensions, boolean addFileUpload) {
        this.setup(addFileUpload);
        this.setAccept(validFileExtensions);
    }

    void setup(boolean addFileUpload) {
        this.up = this.createUploadWidget(addFileUpload);
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.formEncoder.addUtf8Charset(this.form);
        this.form.addSubmitCompleteHandler(new AbstractForm.SubmitCompleteHandler(){

            public void onSubmitComplete(AbstractForm.SubmitCompleteEvent event) {
                if ("OK".equalsIgnoreCase(event.getResults())) {
                    AttachmentFileWidget.this.executeCallback(AttachmentFileWidget.this.successCallback);
                    AttachmentFileWidget.this.showMessage(CommonConstants.INSTANCE.UploadSuccess());
                } else {
                    AttachmentFileWidget.this.executeCallback(AttachmentFileWidget.this.errorCallback);
                    if (event.getResults().contains("org.uberfire.java.nio.file.FileAlreadyExistsException")) {
                        AttachmentFileWidget.this.showMessage(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.ExceptionFileAlreadyExists0(AttachmentFileWidget.this.fieldFileName.getText()));
                    } else if (event.getResults().contains("DecisionTableParseException")) {
                        AttachmentFileWidget.this.showMessage(CommonConstants.INSTANCE.UploadGenericError());
                    } else {
                        AttachmentFileWidget.this.showMessage(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.ExceptionGeneric0(event.getResults()));
                    }
                }
                AttachmentFileWidget.this.reset();
            }
        });
        this.fields.add((Widget)this.up);
        this.fields.add((Widget)this.fieldFilePath);
        this.fields.add((Widget)this.fieldFileName);
        this.fields.add((Widget)this.fieldFileFullPath);
        this.fields.add((Widget)this.fieldFileOperation);
        this.form.add((Widget)this.fields);
        this.initWidget((Widget)this.form);
    }

    FileUpload createUploadWidget(boolean addFileUpload) {
        FileUpload up = new FileUpload(new Command(){

            public void execute() {
                AttachmentFileWidget.this.uploadButtonClickHanlder.onClick(null);
            }
        }, addFileUpload);
        up.setName("fileUploadElement");
        return up;
    }

    private void executeCallback(com.google.gwt.user.client.Command callback) {
        if (callback == null) {
            return;
        }
        callback.execute();
    }

    public void reset() {
        this.form.reset();
    }

    public void submit(Path context, String fileName, String targetUrl, com.google.gwt.user.client.Command successCallback, com.google.gwt.user.client.Command errorCallback) {
        this.submit(fileName, context.toURI(), FileOperation.CREATE, "", targetUrl, successCallback, errorCallback);
    }

    public void submit(Path path, String targetUrl, com.google.gwt.user.client.Command successCallback, com.google.gwt.user.client.Command errorCallback) {
        this.submit("", "", FileOperation.UPDATE, path.toURI(), targetUrl, successCallback, errorCallback);
    }

    void submit(String fileName, String filePath, FileOperation operation, String fileFullPath, String targetUrl, com.google.gwt.user.client.Command successCallback, com.google.gwt.user.client.Command errorCallback) {
        this.setCallbacks(successCallback, errorCallback);
        this.fieldFileName.setText(fileName);
        this.fieldFilePath.setText(filePath);
        this.fieldFileOperation.setText(operation.toString());
        this.fieldFileFullPath.setText(fileFullPath);
        this.form.setAction(targetUrl);
        if (this.isValid()) {
            this.form.submit();
        }
    }

    void setCallbacks(com.google.gwt.user.client.Command successCallback, com.google.gwt.user.client.Command errorCallback) {
        this.successCallback = successCallback;
        this.errorCallback = errorCallback;
    }

    boolean isValid() {
        String fileName = this.up.getFilename();
        if (fileName == null || "".equals(fileName)) {
            this.showMessage(CommonConstants.INSTANCE.UploadSelectAFile());
            this.executeCallback(this.errorCallback);
            return false;
        }
        if (this.validFileExtensions != null && this.validFileExtensions.length != 0) {
            boolean isValid = false;
            for (String extension : this.validFileExtensions) {
                if (!this.hasExtension(fileName, extension)) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                this.showMessage(CommonConstants.INSTANCE.UploadFileTypeNotSupported() + "\n\n" + CommonConstants.INSTANCE.UploadFileTypeSupportedExtensions0(this.makeValidFileExtensionsText()));
                this.executeCallback(this.errorCallback);
                return false;
            }
        }
        return true;
    }

    private boolean hasExtension(String fileName, String extension) {
        String dotExtension = "." + extension;
        return fileName.endsWith(dotExtension) && fileName.length() > dotExtension.length();
    }

    private String makeValidFileExtensionsText() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.validFileExtensions.length; ++i) {
            sb.append("\"").append(this.validFileExtensions[i]).append(i < this.validFileExtensions.length - 1 ? "\", " : "\"");
        }
        return sb.toString();
    }

    private void setAccept(String[] validFileExtensions) {
        this.validFileExtensions = validFileExtensions;
        InputElement element = (InputElement)this.up.getElement().cast();
        element.setAccept(this.makeAcceptString(validFileExtensions));
    }

    private String makeAcceptString(String[] validFileExtensions) {
        if (validFileExtensions == null || validFileExtensions.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String fileExtension : validFileExtensions) {
            sb.append(fileExtension).append(",");
        }
        sb.substring(0, sb.length() - 1);
        return sb.toString();
    }

    private TextBox getHiddenField(String name, String value) {
        TextBox t = new TextBox();
        t.setName(name);
        t.setText(value);
        t.setVisible(false);
        return t;
    }

    public void addClickHandler(ClickHandler clickHandler) {
        this.uploadButtonClickHanlder = clickHandler;
    }

    public void setEnabled(boolean b) {
        this.up.setEnabled(b);
    }

    public void showMessage(String message) {
        Window.alert((String)message);
    }

    public String getFilenameSelectedToUpload() {
        return this.up.getFilename();
    }
}

