/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.cards;

import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.widgets.client.cards.CardComponent;
import org.kie.workbench.common.widgets.client.cards.frame.CardFrameComponent;
import org.uberfire.client.mvp.UberElemental;

public class CardsGridComponent {
    private final View view;
    private final ManagedInstance<CardFrameComponent> cardFrameInstances;
    private HTMLElement emptyStateElement;
    private List<CardFrameComponent> cardFrames = new ArrayList<CardFrameComponent>();

    @Inject
    public CardsGridComponent(View view, ManagedInstance<CardFrameComponent> cardFrameInstances) {
        this.view = view;
        this.cardFrameInstances = cardFrameInstances;
    }

    @PostConstruct
    void init() {
        this.view.init(this);
    }

    public void setupCards(List<CardComponent> cards) {
        this.setCardFrames(this.asFrames(cards));
        this.getView().clearGrid();
        this.asElements(this.getCardFrames()).forEach(this.getView()::appendCard);
        this.setupEmptyState(this.getCardFrames().isEmpty());
    }

    public void setEmptyState(HTMLElement emptyStateElement) {
        this.emptyStateElement = emptyStateElement;
    }

    private List<HTMLElement> asElements(List<CardFrameComponent> cards) {
        return cards.stream().map(CardFrameComponent::getElement).collect(Collectors.toList());
    }

    private List<CardFrameComponent> asFrames(List<CardComponent> cards) {
        return cards.stream().map(this::makeFrame).collect(Collectors.toList());
    }

    private void setupEmptyState(boolean isEmptyStateEnabled) {
        if (isEmptyStateEnabled && this.getEmptyStateElement().isPresent()) {
            this.view.appendCard(this.getEmptyStateElement().get());
        }
    }

    public void enableReadOnlyModeForAllCards() {
        this.getCardFrames().forEach(CardFrameComponent::enableReadOnlyMode);
    }

    List<CardFrameComponent> getCardFrames() {
        return this.cardFrames;
    }

    void setCardFrames(List<CardFrameComponent> cardFrames) {
        this.cardFrames = cardFrames;
    }

    View getView() {
        return this.view;
    }

    private Optional<HTMLElement> getEmptyStateElement() {
        return Optional.ofNullable(this.emptyStateElement);
    }

    private CardFrameComponent makeFrame(CardComponent card) {
        CardFrameComponent frame = (CardFrameComponent)this.cardFrameInstances.get();
        frame.initialize(this, card);
        return frame;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public static interface View
    extends UberElemental<CardsGridComponent>,
    IsElement {
        public void clearGrid();

        public void appendCard(HTMLElement var1);
    }
}

