/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.project.PackageItem;
import org.kie.workbench.common.widgets.client.handlers.PackageListBoxView;
import org.uberfire.mvp.Command;

@Dependent
public class PackageListBox
implements IsElement {
    private PackageListBoxView view;
    private WorkspaceProjectContext projectContext;
    protected Caller<KieModuleService> moduleService;
    private Map<String, PackageItem> packages;
    private Package selectedPackage = null;

    @Inject
    public PackageListBox(PackageListBoxView view, WorkspaceProjectContext projectContext, Caller<KieModuleService> moduleService) {
        this.view = view;
        this.projectContext = projectContext;
        this.moduleService = moduleService;
        this.packages = new HashMap<String, PackageItem>();
        view.setPresenter(this);
    }

    public void setUp(boolean includeDefaultPackage) {
        this.setUp(includeDefaultPackage, null);
    }

    public void setUp(boolean includeDefaultPackage, Command packagesLoadedCommand) {
        this.packages.clear();
        this.showListOfPackages(includeDefaultPackage, packagesLoadedCommand);
    }

    public void clearSelectElement() {
        this.view.clearSelectElement();
    }

    private void showListOfPackages(boolean includeDefaultPackage, Command packagesLoadedCommand) {
        Module activeModule = this.projectContext.getActiveModule().orElse(null);
        if (activeModule != null) {
            ((KieModuleService)this.moduleService.call(kieModulePackages -> {
                List<PackageItem> sortedPackages = this.getSortedPackages(includeDefaultPackage, kieModulePackages.getPackages());
                if (sortedPackages.isEmpty()) {
                    return;
                }
                this.addPackagesToSelect(sortedPackages, kieModulePackages.getDefaultPackage());
                if (packagesLoadedCommand != null) {
                    packagesLoadedCommand.execute();
                }
            })).resolveModulePackages(activeModule);
        }
    }

    private List<PackageItem> getSortedPackages(boolean includeDefaultPackage, Set<PackageItem> pkgs) {
        ArrayList<PackageItem> sortedPackages = new ArrayList<PackageItem>(pkgs);
        Collections.sort(sortedPackages, (p1, p2) -> p1.getCaption().compareTo(p2.getCaption()));
        if (!includeDefaultPackage && !sortedPackages.isEmpty() && "".equals(((PackageItem)sortedPackages.get(0)).getPackageName())) {
            sortedPackages.remove(0);
        }
        return sortedPackages;
    }

    private void addPackagesToSelect(List<PackageItem> sortedPackages, Package activePackage) {
        HashMap<String, String> packageNames = new HashMap<String, String>();
        for (PackageItem pkg : sortedPackages) {
            packageNames.put(pkg.getCaption(), pkg.getPackageName());
            this.packages.put(pkg.getCaption(), pkg);
        }
        this.setSelectedPackage(activePackage);
        String selectedPackageName = this.resolve(this.getSelectedPackageName(activePackage, packageNames));
        this.view.setUp(selectedPackageName, packageNames);
    }

    private String getSelectedPackageName(Package activePackage, Map<String, String> packageNames) {
        if (packageNames.containsKey(activePackage.getCaption())) {
            return activePackage.getCaption();
        }
        if (!packageNames.isEmpty()) {
            String next = packageNames.keySet().iterator().next();
            this.setSelectedPackage(next);
            return next;
        }
        return null;
    }

    private void setSelectedPackage(String selectedPackage) {
        Module activeModule = this.projectContext.getActiveModule().orElse(null);
        if (activeModule == null) {
            return;
        }
        ((KieModuleService)this.moduleService.call(this::setSelectedPackage)).resolvePackage(activeModule, this.resolve(selectedPackage));
    }

    private void setSelectedPackage(Package selectedPackage) {
        this.selectedPackage = selectedPackage;
    }

    public Package getSelectedPackage() {
        return this.selectedPackage;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void onPackageSelected(String selectedPackage) {
        this.setSelectedPackage(this.resolve(selectedPackage));
    }

    private String resolve(String selectedPackage) {
        if (Objects.equals("<default>", selectedPackage)) {
            return "";
        }
        return selectedPackage;
    }
}

