/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import java.util.Map;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Label;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSService;

public class PathLabel
extends Label {
    @Inject
    private Caller<VFSService> vfsService;
    private Path activePath;

    public void setPath(final Path path) {
        if (path == null) {
            this.setText(CommonConstants.INSTANCE.ItemUndefinedPath());
            return;
        }
        try {
            ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<Map>(){

                public void callback(Map response) {
                    if (PathLabel.this.isRegularFile(response)) {
                        PathLabel.this.activePath = PathLabel.this.stripFileName(path);
                        PathLabel.this.setText(PathLabel.this.activePath.toURI());
                    } else {
                        PathLabel.this.activePath = path;
                        PathLabel.this.setText(PathLabel.this.activePath.toURI());
                    }
                }
            })).readAttributes(path);
        }
        catch (Exception e) {
            this.activePath = path;
            this.setText(this.activePath.toURI());
        }
    }

    private boolean isRegularFile(Map response) {
        return response != null && response.containsKey("isRegularFile") && (Boolean)response.get("isRegularFile") != false;
    }

    public Path getPath() {
        return this.activePath;
    }

    private Path stripFileName(Path path) {
        String uri = path.toURI();
        uri = uri.replace(path.getFileName(), "");
        return PathFactory.newPathBasedOn((String)path.getFileName(), (String)uri, (Path)path);
    }
}

