/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import elemental2.dom.Element;
import elemental2.dom.HTMLTableElement;
import elemental2.dom.HTMLTableSectionElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.widgets.client.widget.ListItemPresenter;

public abstract class ListPresenter<T, P extends ListItemPresenter<T, ?, ?>> {
    private static final Elemental2DomUtil elemental2DomUtil = new Elemental2DomUtil();
    private final Function<T, P> itemPresenters;
    private List<T> objects;
    private List<P> presenters;
    private Element listElement;
    private BiConsumer<T, P> itemPresenterConfigurator;

    public ListPresenter(Function<T, P> itemPresenters) {
        this.itemPresenters = itemPresenters;
    }

    public ListPresenter(ManagedInstance<P> itemPresenters) {
        this.itemPresenters = item -> (ListItemPresenter)itemPresenters.get();
    }

    public void setup(Element listElement, List<T> objects, BiConsumer<T, P> itemPresenterConfigurator) {
        this.objects = objects;
        this.presenters = new ArrayList<P>();
        this.listElement = listElement;
        this.itemPresenterConfigurator = itemPresenterConfigurator;
        this.handleTable();
        elemental2DomUtil.removeAllElementChildren((Node)this.listElement);
        this.objects.forEach(this::addToListElement);
    }

    public void setupWithPresenters(Element listElement, List<P> presenters, BiConsumer<T, P> itemPresenterConfigurator) {
        this.objects = presenters.stream().map(p -> p.getObject()).collect(Collectors.toList());
        this.presenters = presenters;
        this.listElement = listElement;
        this.itemPresenterConfigurator = itemPresenterConfigurator;
        this.handleTable();
        elemental2DomUtil.removeAllElementChildren((Node)this.listElement);
        presenters.forEach(this::addPresenter);
    }

    private void handleTable() {
        if (this.listElement instanceof HTMLTableSectionElement) {
            HTMLTableElement tableElement = (HTMLTableElement)this.listElement.parentNode;
            if (this.objects.isEmpty()) {
                tableElement.classList.add(new String[]{"hidden"});
            } else {
                tableElement.classList.remove(new String[]{"hidden"});
            }
        }
    }

    public void add(T o) {
        this.addToListElement(o);
        this.objects.add(o);
        this.handleTable();
    }

    public void addToListElement(T o) {
        this.addPresenter(this.newPresenterFor(o));
    }

    public void addPresenter(P presenter) {
        this.presenters.add(presenter);
        this.listElement.appendChild((Node)((ListItemPresenter)presenter).getView().getElement());
    }

    public P newPresenterFor(T o) {
        ListItemPresenter listItemPresenter = (ListItemPresenter)this.itemPresenters.apply(o);
        listItemPresenter.setListPresenter(this);
        this.itemPresenterConfigurator.accept(o, listItemPresenter);
        return (P)listItemPresenter;
    }

    public void remove(ListItemPresenter<T, ?, ?> listItemPresenter) {
        this.objects.remove(listItemPresenter.getObject());
        this.listElement.removeChild((Node)listItemPresenter.getView().getElement());
        this.handleTable();
    }

    public List<T> getObjectsList() {
        return this.objects;
    }

    public List<P> getPresenters() {
        return this.presenters;
    }
}

