/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.callbacks;

import java.util.List;
import javax.enterprise.event.Event;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public class AssetValidatedCallback
implements RemoteCallback<List<ValidationMessage>> {
    private final Command validationFinishedCommand;
    private final Event<NotificationEvent> notificationEvent;
    private ValidationPopup validationPopup;

    public AssetValidatedCallback(Command validationFinishedCommand, Event<NotificationEvent> notificationEvent, ValidationPopup validationPopup) {
        this.validationFinishedCommand = validationFinishedCommand;
        this.notificationEvent = notificationEvent;
        this.validationPopup = validationPopup;
    }

    public void callback(List<ValidationMessage> validationMessages) {
        if (validationMessages == null || validationMessages.isEmpty()) {
            this.notifyValidationSuccess();
        } else {
            this.validationPopup.showMessages(validationMessages);
        }
        if (this.validationFinishedCommand != null) {
            this.validationFinishedCommand.execute();
        }
    }

    private void notifyValidationSuccess() {
        if (this.notificationEvent != null) {
            this.notificationEvent.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
        }
    }
}

