/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.ruleselector;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

public class RuleSelector
extends Composite
implements HasValueChangeHandlers<String>,
HasEnabled {
    public static final String NONE_SELECTED = CommonConstants.INSTANCE.LineNoneLine();
    private boolean ruleNamesLoaded = false;
    private Optional<Command> onRulesLoadedCommand = Optional.empty();
    private Select ruleNameSelector = (Select)GWT.create(Select.class);

    public RuleSelector() {
        this.ruleNameSelector.setEnabled(false);
        this.ruleNameSelector.setLiveSearch(true);
        this.ruleNameSelector.setLiveSearchPlaceholder(CommonConstants.INSTANCE.Choose());
        this.ruleNameSelector.removeStyleName("form-control");
        this.ruleNameSelector.add((Widget)this.makeRuleNameOption(NONE_SELECTED, ""));
        this.initWidget((Widget)this.ruleNameSelector);
    }

    public void setRuleNames(Collection<String> ruleNames, String exclude) {
        this.setRuleNames(this.exclude(ruleNames, exclude));
    }

    public void setRuleNames(Collection<String> ruleNames) {
        if (ruleNames != null && !ruleNames.isEmpty()) {
            this.ruleNamesLoaded = true;
            this.ruleNameSelector.setEnabled(true);
            ruleNames.forEach(r -> this.ruleNameSelector.add((Widget)this.makeRuleNameOption(this.getSimpleRuleName((String)r))));
            this.onRulesLoadedCommand.ifPresent(Command::execute);
        } else {
            this.ruleNameSelector.setEnabled(false);
        }
        this.ruleNameSelector.refresh();
    }

    Option makeRuleNameOption(String ruleName) {
        return this.makeRuleNameOption(ruleName, ruleName);
    }

    Option makeRuleNameOption(String ruleName, String value) {
        Option o = (Option)GWT.create(Option.class);
        String simpleRuleName = this.getSimpleRuleName(ruleName);
        o.setText(simpleRuleName);
        o.setValue(value);
        return o;
    }

    String getSimpleRuleName(String ruleName) {
        if (ruleName.contains(".")) {
            return ruleName.substring(ruleName.lastIndexOf(".") + 1);
        }
        return ruleName;
    }

    private Collection<String> exclude(Collection<String> ruleNames, String exclude) {
        return ruleNames.stream().map(this::getSimpleRuleName).filter(r -> !r.equals(exclude)).collect(Collectors.toList());
    }

    public String getRuleName() {
        String ruleName = this.ruleNameSelector.getValue();
        if (ruleName != null && !ruleName.equals(NONE_SELECTED)) {
            return ruleName;
        }
        return "";
    }

    public void setRuleName(String ruleName) {
        if (ruleName != null && !ruleName.isEmpty()) {
            if (this.ruleNamesLoaded) {
                this.ruleNameSelector.setValue((Object)ruleName);
            } else {
                this.onRulesLoadedCommand = Optional.of(() -> this.setRuleName(ruleName));
            }
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.ruleNameSelector.addValueChangeHandler(handler);
    }

    public boolean isEnabled() {
        return this.ruleNameSelector.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.ruleNameSelector.setEnabled(enabled);
    }
}

