/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.shared.kmodule.KBaseModel;
import org.kie.workbench.common.services.shared.kmodule.KModuleModel;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.kmodule.KSessionModel;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.widgets.client.widget.KSessionSelectorView;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mvp.Command;

public class KSessionSelector
implements IsWidget {
    private static String DEFAULT_KIE_BASE = "defaultKieBase";
    private static String DEFAULT_KIE_SESSION = "defaultKieSession";
    private static String NON_EXISTING_KBASE = "---";
    private KSessionSelectorView view;
    private Caller<KieModuleService> moduleService;
    private Caller<KModuleService> kModuleService;
    private KModuleModel kmodule;
    private Command selectionHandler;

    @Inject
    public KSessionSelector(KSessionSelectorView view, Caller<KieModuleService> moduleService, Caller<KModuleService> kModuleService) {
        this.view = view;
        this.moduleService = moduleService;
        this.kModuleService = kModuleService;
        view.setPresenter(this);
    }

    public void init(Path path, String ksession) {
        ((KieModuleService)this.moduleService.call(this.getSuccessfulResolveModuleCallback(ksession))).resolveModule(path);
    }

    private RemoteCallback<KieModule> getSuccessfulResolveModuleCallback(final String currentKSession) {
        return new RemoteCallback<KieModule>(){

            public void callback(KieModule module) {
                ((KModuleService)KSessionSelector.this.kModuleService.call(KSessionSelector.this.getSuccessfulLoadKModuleCallback(currentKSession))).load(module.getKModuleXMLPath());
            }
        };
    }

    private RemoteCallback<KModuleModel> getSuccessfulLoadKModuleCallback(final String currentKSession) {
        return new RemoteCallback<KModuleModel>(){

            public void callback(KModuleModel kmodule) {
                KSessionSelector.this.kmodule = kmodule;
                KSessionSelector.this.initKBases(currentKSession);
                KSessionSelector.this.selectCurrentKBaseAndKSession(currentKSession);
            }
        };
    }

    private void selectCurrentKBaseAndKSession(String currentKSession) {
        if (this.isNotNullOrEmpty(currentKSession) && this.kmoduleContainsCurrentKSession(currentKSession)) {
            this.selectFromModel(currentKSession);
        } else {
            this.selectFirstKBaseAndKSession();
        }
    }

    private void initKBases(String currentKSession) {
        ArrayList<String> kbaseNames = new ArrayList<String>();
        if (this.kmodule.getKBases().isEmpty()) {
            this.addMockKBaseModel(DEFAULT_KIE_BASE, DEFAULT_KIE_SESSION);
            kbaseNames.add(DEFAULT_KIE_BASE);
        } else {
            for (KBaseModel kBase : this.kmodule.getKBases().values()) {
                kbaseNames.add(kBase.getName());
            }
        }
        Collections.sort(kbaseNames, (first, other) -> first.compareToIgnoreCase((String)other));
        if (this.isNotNullOrEmpty(currentKSession) && !this.kmoduleContainsCurrentKSession(currentKSession)) {
            this.addMockKBaseModel(NON_EXISTING_KBASE, currentKSession);
            kbaseNames.add(NON_EXISTING_KBASE);
            this.view.showWarningSelectedKSessionDoesNotExist();
        }
        this.view.addKBases(kbaseNames.toArray(new String[kbaseNames.size()]));
    }

    private void addMockKBaseModel(String kbaseName, String ksessionsName) {
        KBaseModel kbaseModel = new KBaseModel();
        kbaseModel.setName(kbaseName);
        KSessionModel ksessionModel = new KSessionModel();
        ksessionModel.setName(ksessionsName);
        kbaseModel.getKSessions().add(ksessionModel);
        this.kmodule.getKBases().put(kbaseName, kbaseModel);
    }

    private boolean isNotNullOrEmpty(String ksession) {
        return ksession != null && !ksession.trim().isEmpty();
    }

    private boolean kmoduleContainsCurrentKSession(String currentKSession) {
        if (this.isNotNullOrEmpty(currentKSession)) {
            for (KBaseModel kbase : this.kmodule.getKBases().values()) {
                for (KSessionModel ksession : kbase.getKSessions()) {
                    if (!ksession.getName().equals(currentKSession)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void onKBaseSelected(String kbaseName) {
        List ksessions = ((KBaseModel)this.kmodule.getKBases().get(kbaseName)).getKSessions();
        this.listKSessions(ksessions);
        this.view.setSelected(kbaseName, ((KSessionModel)ksessions.iterator().next()).getName());
    }

    public String getSelectedKSessionName() {
        return this.view.getSelectedKSessionName();
    }

    private void selectFromModel(String currentKSession) {
        block0: for (KBaseModel kbase : this.kmodule.getKBases().values()) {
            for (KSessionModel ksession : kbase.getKSessions()) {
                if (!ksession.getName().equals(currentKSession)) continue;
                this.listKSessions(((KBaseModel)this.kmodule.getKBases().get(kbase.getName())).getKSessions());
                this.view.setSelected(kbase.getName(), currentKSession);
                continue block0;
            }
        }
    }

    private void selectFirstKBaseAndKSession() {
        KBaseModel firstKBase = (KBaseModel)this.kmodule.getKBases().values().iterator().next();
        List ksessions = firstKBase.getKSessions();
        this.listKSessions(ksessions);
        this.view.setSelected(firstKBase.getName(), ((KSessionModel)ksessions.iterator().next()).getName());
    }

    private void listKSessions(List<KSessionModel> ksessions) {
        ArrayList<String> ksessionNames = new ArrayList<String>();
        for (KSessionModel ksession : ksessions) {
            ksessionNames.add(ksession.getName());
        }
        this.view.setKSessions(ksessionNames);
    }

    public Widget asWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public void onSelectionChange() {
        if (this.selectionHandler != null) {
            this.selectionHandler.execute();
        }
    }

    public void setSelectionChangeHandler(Command handler) {
        this.selectionHandler = (Command)PortablePreconditions.checkNotNull((String)"handler", (Object)handler);
    }
}

